package cn.com.duiba.remoteimpl.cmb;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.thirdparty.api.cmb.RemoteCmbMachineService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

/**
 * @program: thirdparty-all
 * @description:
 * @author: Simba
 * @create: 2019-01-28 12:12
 **/
@RestController
public class RemoteCmbMachineServiceImpl implements RemoteCmbMachineService {

    private static Logger logger = LoggerFactory.getLogger(RemoteCmbMachineServiceImpl.class);

    @Override
    public String sendCmbMachineRequest(String ipPort, String data) throws BizException {
        StringBuilder result = new StringBuilder();

        if (StringUtils.isBlank(ipPort)) {
            logger.info("前置机ip端口不可为空");
            return null;
        }
        HttpURLConnection conn = null;
        try {
            String machineUrl = "http://" + ipPort;
            URL url = new URL(machineUrl);

            conn = (HttpURLConnection) url.openConnection();

            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);

            try (OutputStream os = conn.getOutputStream()) {
                os.write(data.getBytes(StandardCharsets.UTF_8));
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()))) {
                String line;
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
            }
        } catch (MalformedURLException e) {
            throw new BizException("连接配置异常" + e.getMessage());
        } catch (IOException e) {
            throw new BizException("流配置异常" + e.getMessage());
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result.toString();
    }
}

