package cn.com.duiba.tool.puhui;

import cn.hutool.core.codec.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

/**
 * @author zdq
 * @Description
 * @createTime 2021年05月29日 13:49:00
 */
public class AESEncodeUtil {
    private static Logger log = LoggerFactory.getLogger(AESEncodeUtil.class);


    /**
     * 将base 64 code AES解密
     *
     * @param contentString 待解密的base 64 code
     * @param keyString     解密密钥
     * @return 解密后的string
     * @throws Exception
     */
    public static String aesDecrypt(String contentString, String keyString) {
        String decryptString = "404";
        try {
            if (!"".equals(contentString)) {
                decryptString = aesDecryptByBytes(base64Decode(contentString), keyString);
            }
        } catch (Exception e) {
            log.error("解密发生异常：" + e);
            if (e instanceof BadPaddingException) {
                return "404";
            }
        }
        return decryptString;
    }

    /**
     * AES解密
     *
     * @param encryptBytes 待解密的byte[]
     * @param decryptKey   解密密钥
     * @return 解密后的String
     * @throws NoSuchAlgorithmException
     * @throws NoSuchPaddingException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     * @throws Exception
     */
    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(decryptKey.getBytes());
        kgen.init(128, random);

        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(kgen.generateKey().getEncoded(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    /**
     * base 64 decode
     *
     * @param base64Code 待解码的base 64 code
     * @return 解码后的byte[]
     * @throws IOException
     * @throws Exception
     */
    public static byte[] base64Decode(String base64Code) throws IOException {
        return "".equals(base64Code) ? null : Base64.decode(base64Code);
    }

    /**
     * AES加密为base 64 code
     *
     * @param contentString 待加密的内容
     * @param keyString     加密密钥
     * @return 加密后的base 64 code
     * @throws UnsupportedEncodingException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeyException
     * @throws Exception
     */
    public static String aesEncrypt(String contentString, String keyString) {
        String result = "";
        try {
            result = base64Encode(aesEncryptToBytes(contentString, keyString));
        } catch (Throwable e) {
            log.error("AES Encrypt error", e);
            throw new RuntimeException("AES Encrypt error");
        }
        return result;
    }

    /**
     * base 64 encode
     *
     * @param bytes 待编码的byte[]
     * @return 编码后的base 64 code
     */
    public static String base64Encode(Object bytes) {
        return Base64.encode((byte[]) bytes);
    }

    /**
     * AES加密
     *
     * @param content    待加密的内容
     * @param encryptKey 加密密钥
     * @return 加密后的byte[]
     * @throws NoSuchAlgorithmException
     * @throws NoSuchPaddingException
     * @throws InvalidKeyException
     * @throws UnsupportedEncodingException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     * @throws Exception
     * @throws Exception
     */
    public static Object aesEncryptToBytes(String content, String encryptKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(encryptKey.getBytes());
        kgen.init(128, random);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(kgen.generateKey().getEncoded(), "AES"));

        return cipher.doFinal(content.getBytes("utf-8"));
    }

    /**
     * 结合base64实现md5加密
     *
     * @param msg 待加密字符串
     * @return 获取md5后转为base64
     * @throws NoSuchAlgorithmException
     * @throws Exception
     */
    public static String md5Encrypt(String msg) throws NoSuchAlgorithmException {
        return "".equals(msg) ? null : base64Encode(md5(msg.getBytes()));
    }

    /**
     * 获取byte[]的md5值
     *
     * @param bytes byte[]
     * @return md5
     * @throws NoSuchAlgorithmException
     * @throws Exception
     */
    public static byte[] md5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        return md.digest();
    }


    public static void main(String[] args) throws UnsupportedEncodingException {
        String value =  "HVSzaPclANU0HnqHSjEK+haSeN54SAz/zrk+FtK6eQ7DGOklJ2M/MyA0TOkh7ZXv92SJ43Z9Pip1mbO+Qos7chDAYPag1XS3JAQ/fEQMDXA7n22ZK+biyu4fZLKhuwgBj7aq0C8d3pOxKRnXFQpTeSj9elQK2ZgpG4xnvr7VL7VvVukmz8bFji8+Yn+X70y1GvBuZQQu0/0b7aX/LRfhsh0EHZdTcgJ6L5uq8PbnbN4=";
        //3050sk6g6sner4e1
        String keyString = "3050sk6g6sner4el";


        //String encode = URLEncoder.encode(value, "UTF-8");
        //String s2 = Base64.encode(value);

        String resp = aesDecrypt(value, keyString);
        System.out.println(URLDecoder.decode(resp,"UTF-8"));



    }
}
