package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.api.enums.subcredits.SubCreditsType;
import cn.com.duiba.constant.MingYuJiuDianConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.greencloud.guardian.sdk.Client;
import com.greencloud.guardian.sdk.Request;
import com.greencloud.guardian.sdk.Response;
import com.greencloud.guardian.sdk.constant.Constants;
import com.greencloud.guardian.sdk.constant.HttpSchema;
import com.greencloud.guardian.sdk.enums.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description:
 */
@Service
public class MingYuJiuDianApi {
    private static final Logger logger = LoggerFactory.getLogger(MingYuJiuDianApi.class);

    private static final String PROMOTIONTAG = "DUIBA";
    private static final String REMARK = "兑吧积分记录DUIBA_POINT";
    private static final String CARD_POINT_USE_DTO = "cardPointUse";

    //自定义参与签名Header前缀（可选,默认只有"X-Gw-"开头的参与到Header签名）
    private final static List<String> CUSTOM_HEADERS_TO_SIGN_PREFIX = new ArrayList<>();

    @Autowired
    private MingYuJiuDianConfig mingYuJiuDianConfig;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    public boolean isAppId(Long appId) {
        return mingYuJiuDianConfig.getAppIds().contains(appId);
    }


    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String orderNum = message.getSubCreditsMsg().getCreditConsumeParams().getOrderNum();

        Map<String, String> newParams = new HashMap<>(8);

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        Long credits = message.getSubCreditsMsg().getCreditConsumeParams().getCredits();
        String memberId = message.getSubCreditsMsg().getAuthParams().get("uid");
        String crsNo = message.getSubCreditsMsg().getRelationId();
        SubCreditsType relationType = message.getSubCreditsMsg().getRelationType();

        newParams.put("sessionId", sessionId);
        newParams.put("point", credits.toString());
        newParams.put("memberId", memberId);
        newParams.put("promotionTag", PROMOTIONTAG);
        // 普兑时，取带C的订单号
        newParams.put("crsNo", relationType == SubCreditsType.MALL ? orderNum : crsNo);
        newParams.put("remark", REMARK);

        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getSubCreditsUrl());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair pointPair = new BasicNameValuePair("point", credits.toString());
        NameValuePair cardIdPair = new BasicNameValuePair("memberId", memberId);
        NameValuePair promotionTagPair = new BasicNameValuePair("promotionTag", PROMOTIONTAG);
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        NameValuePair crsNoPair = new BasicNameValuePair("crsNo", relationType == SubCreditsType.MALL ? orderNum : crsNo);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());

        pairList.add(sessionIdPair);
        pairList.add(pointPair);
        pairList.add(cardIdPair);
        pairList.add(promotionTagPair);
        pairList.add(remarkPair);
        pairList.add(crsNoPair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);

        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    public String getResponseCredits(String body, Long appId, Boolean addCredits, Map<String, String> authParams) {
        String orderNum = authParams.get("orderNum");
        logger.info("MingYuJiuDian getResponseCredits,body:{},orderNum={}", body, orderNum);
        JSONObject jsonObject = JSONObject.parseObject(body);

        if (jsonObject == null || jsonObject.getInteger("resultCode") != 0) {
            logger.warn("MingYuJiuDian sub credits error,body:{},orderNum={}", body, orderNum);
            return body;
        }

        Map<String, String> param = new HashMap<>();

        if (addCredits) {
            Long pointPayId = jsonObject.getLong("pointPayId");
            if (pointPayId == null) {
                logger.warn("MingYuJiuDian add credits error,pointPayId is null,body:{},orderNum={}", body, orderNum);
                return body;
            }
            param.put("bizId", pointPayId.toString());
        } else {

            JSONArray resultJSONArray = jsonObject.getJSONArray("result");
            if (resultJSONArray == null || resultJSONArray.size() == 0) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{},orderNum={}", body, orderNum);
                return body;
            }
            logger.info("MingYuJiuDian,cardPointUse,body:{},orderNum={}", resultJSONArray.toJSONString(), orderNum);
            JSONObject result = resultJSONArray.getJSONObject(0);
            if (result == null) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{},orderNum={}", body, orderNum);
                return body;
            }
            Integer pointId = result.getInteger("pointId");
            if (pointId == null) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{},orderNum={}", body, orderNum);
                return body;
            }
            param.put("bizId", String.valueOf(pointId));

            // 本次的积分使用 使用了那些卡的积分，使用了多少张卡
            // 最多两张卡
            JSONObject object = new JSONObject();
            object.put(CARD_POINT_USE_DTO, resultJSONArray.toJSONString());
            logger.info("MingYuJiuDian,cardPointUse,save,body:{},orderNum={}", resultJSONArray.toJSONString(), orderNum);
            param.put(SubCreditsResultMsgDto.EXTRA_INFO, object.toJSONString());

        }

        param.put("status", "ok");
        try {
            String uid = authParams.get("uid");
            String credits = mingYuJiuDianConfig.getCredits(uid, httpClient);

            if (!"0".equals(credits)) {
                param.put("credits", String.valueOf(new BigDecimal(credits).longValue()));
            }

        } catch (Exception e) {
            logger.warn("get Credits error");
        }


        return JSONObject.toJSONString(param);


    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        Map<String, String> newParams = new HashMap<>();

        String httpUrl = message.getHttpUrl();
        String paramsStr = httpUrl.substring(httpUrl.indexOf('?') + 1);
        Map<String, String> authParams = cn.com.duiba.tool.AssembleTool.getUrlParams(paramsStr);

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        String credits = authParams.get("credits");
        String cardId = message.getParams().get("cardId");

        newParams.put("sessionId", sessionId);
        newParams.put("point", credits);
        newParams.put("cardId", cardId);
        newParams.put("promotionTag", PROMOTIONTAG);
        newParams.put("remark", REMARK);

        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getAddCreditsUrl());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair pointPair = new BasicNameValuePair("point", credits);
        NameValuePair cardIdPair = new BasicNameValuePair("cardId", cardId);
        NameValuePair promotionTagPair = new BasicNameValuePair("promotionTag", PROMOTIONTAG);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);

        pairList.add(sessionIdPair);
        pairList.add(pointPair);
        pairList.add(cardIdPair);
        pairList.add(promotionTagPair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);

        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        return httpPost;
    }

    /**
     * 虚拟商品发货
     *
     * @param message
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest message) {
        String url = message.getHttpUrl();
        String authParams = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");

        if (StringUtils.isNotBlank(goodsNum)) {
            //如果是礼包商品
            if (goodsNum.startsWith(mingYuJiuDianConfig.getCoupons1())) {
                return getCoupons1VirtualRequest(message, authParamMap);
            }
            //如果是电子券商品
            if (goodsNum.startsWith(mingYuJiuDianConfig.getCoupons2())) {
                return getCoupons2VirtualRequest(message, authParamMap);
            }

            // 加积分
            if (goodsNum.startsWith(mingYuJiuDianConfig.getCredits())) {
                return getCreditsVirtualRequest(message, authParamMap);
            }
        }
        return new HttpGet(url);
    }

    private HttpRequestBase getCreditsVirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        // 解析出host+param
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);

        // 解析出credits
        String goodsNum = authParamMap.get("params");
        String creditsStr = goodsNum.replaceFirst(mingYuJiuDianConfig.getCredits(), "");
        long credits = Long.parseLong(creditsStr);

        logger.info("明宇酒店,虚拟商品充值,加积分,orderId-={},goodsNum={}", message.getOrderId(), goodsNum);

        // 伪造一个CreditsMessageDto
        CreditsMessageDto creditsMessageDto = new CreditsMessageDto();
        Map<String, String> authParams = new HashMap<>();
        authParams.put("credits", String.valueOf(credits));
        creditsMessageDto.setHttpUrl(AssembleTool.assembleUrl(newUrl, authParams));
        creditsMessageDto.setParams(message.getParams());
        return getAddCreditsHttpRequest(creditsMessageDto);
    }

    /**
     * 礼包商品
     *
     * @param message
     * @param authParamMap
     * @return
     */
    private HttpRequestBase getCoupons1VirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        String goodsNum = authParamMap.get("params").replace(mingYuJiuDianConfig.getCoupons1(), "");

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        String cardId = message.getParams().get("cardId");
        String cardNo = message.getParams().get("cardNo");

        Map<String, String> newParams = new HashMap<>();
        newParams.put("sessionId", sessionId);
        newParams.put("cardId", cardId);
        newParams.put("couponPackCode", goodsNum);
        newParams.put("remark", REMARK);
        newParams.put("cardNo", cardNo);


        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getCoupons1Url());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair cardIdPair = new BasicNameValuePair("cardId", cardId);
        NameValuePair couponPackCodePair = new BasicNameValuePair("couponPackCode", goodsNum);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        NameValuePair cardNoPair = new BasicNameValuePair("cardNo", cardNo);

        pairList.add(sessionIdPair);
        pairList.add(cardIdPair);
        pairList.add(couponPackCodePair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        pairList.add(cardNoPair);


        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        return httpPost;
    }

    /**
     * 电子券商品
     *
     * @param message
     * @param authParamMap
     * @return
     */
    private HttpRequestBase getCoupons2VirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        Map<String, String> newParams = new HashMap<>();
        String goodsNum = authParamMap.get("params").replace(mingYuJiuDianConfig.getCoupons2(), "");

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        String memberId = authParamMap.get("uid");

        newParams.put("sessionId", sessionId);
        newParams.put("couponCode", goodsNum);
        newParams.put("remark", REMARK);
        newParams.put("number", "1");
        newParams.put("memberId", memberId);

        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getCoupons2Url());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair couponPackCodePair = new BasicNameValuePair("couponCode", goodsNum);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        NameValuePair numberPair = new BasicNameValuePair("number", "1");
        NameValuePair memberIdPair = new BasicNameValuePair("memberId", memberId);

        pairList.add(sessionIdPair);
        pairList.add(couponPackCodePair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        pairList.add(numberPair);
        pairList.add(memberIdPair);


        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {

        JSONObject jsonObject = JSONObject.parseObject(body);
        Integer resultCode = jsonObject.getInteger("resultCode");
        Map<String, String> param = new HashMap<>();

        if (resultCode != null && 0 == resultCode) {
            String url = message.getHttpUrl();
            String authParams = url.substring(url.indexOf('?') + 1);
            Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
            String uid = authParamMap.get("uid");
            String credits = mingYuJiuDianConfig.getCredits(uid, httpClient);
            if (!"0".equals(credits)) {
                param.put("credits", String.valueOf(new BigDecimal(credits).longValue()));
            }
            param.put("status", "success");
        } else {
            param.put("status", "fail");
            param.put("errorMessage", jsonObject.getString("resultMsg"));
        }
        param.put("supplierBizId", UUIDUtils.createUUID());
        return JSON.toJSONString(param);
    }

    public String getUserInfo(String token) {
        Map<String, String> headers = new HashMap<>();
        //（必填）根据期望的Response内容类型设置
        CUSTOM_HEADERS_TO_SIGN_PREFIX.clear();

        Request request = new Request(Method.GET, HttpSchema.HTTPS + mingYuJiuDianConfig.getMingyuHost(),
                mingYuJiuDianConfig.getMingyuApiAddress() + mingYuJiuDianConfig.getQueryUserInfoPath(),
                mingYuJiuDianConfig.getAppKey(), mingYuJiuDianConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setSignHeaderPrefixList(CUSTOM_HEADERS_TO_SIGN_PREFIX);

        //请求的query
        Map<String, String> querys = new HashMap<>();
        querys.put("token", token);
        querys.put("appid", mingYuJiuDianConfig.getMingyuWxAppId());
        request.setQuerys(querys);

        //调用服务端
        Response response;
        try {
            response = Client.execute(request);
        } catch (Exception e) {
            logger.warn("明宇酒店接口请求异常,token={}",token, e);
            return null;
        }
        logger.info("明宇酒店接口返回,msg:{}",JSON.toJSONString(response));
        if(response.getStatusCode() == 200) {
            JSONObject ret = JSON.parseObject(response.getBody());
            String msg = ret.getString("msg");
            if(StringUtils.isBlank(msg)) {
                return ret.getString("retVal");
            }
        }
        return null;
    }

}
