package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.config.FudeConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.fude.SignToolJSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Date 2020/12/28
 * @Created by xph
 */
@Component
public class FudeApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(FudeApiStrategy.class);


    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";

    private static final String SUCCESS = "Y";

    @Autowired
    private FudeConfig fudeConfig;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        log.info("福德人寿扣积分开始");
        return null;
    }

    /**
     * 解析返回结果
     * @param body   返回体    :
     * @param addCredits true加积分
     * @param authParams 订单相关参数
     * @return
     */
    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {

        Map<String, String> duibaDoc = new HashMap<>();
        duibaDoc.put("bizId", authParams.get("orderNum"));
        duibaDoc.put("credits", authParams.get("credits"));
        duibaDoc.put("status","fail");
        log.info("福德人寿加积分响应体：{}",body);
        if (addCredits){
            JSONObject jsonObject = JSONObject.parseObject(body);
            String flag = jsonObject.getString("flag");
            if (SUCCESS.equals(flag)){
                duibaDoc.put("status","ok");
                duibaDoc.put("bizId",jsonObject.getString("id"));
            }else {
                log.warn("福德人寿加积分响应失败：{}",body);
                duibaDoc.put("errorMessage",jsonObject.getString("msg"));
            }
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            log.info("福德人寿加积分请求 :{}", JSON.toJSONString(message));
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            Map<String, String> authParams = message.getAuthParams();
            //获取加积分的其他参数
            HashMap<String, String> param = buildParam(authParams);
            log.info("福德人寿加积分请求兑吧uid：{} 实际jfUid:{}", authParams.get("uid"),JSONObject.toJSONString(param));
            String paramStr = JSONObject.toJSONString(param);
            HttpPost httpPost = new HttpPost(host);
            List<NameValuePair> pairs = new ArrayList<>();
            pairs.add(new BasicNameValuePair("param", paramStr));
            httpPost.setEntity(new UrlEncodedFormEntity(pairs,"UTF-8"));
            return  httpPost;
        } catch (Exception e) {
            log.warn("福德人寿加积分请求异常",e);
        }
        return null;
    }

    /**
     * param= {"sign":"138026712f0c643d25eb77d41e6b04b3","integrals": "100","uid": "20210000000031085395","timestamp":"1644310667"}
     * @param authParams
     * @return
     */
    public HashMap<String, String> buildParam( Map<String, String> authParams ){
        String transfer = authParams.get("transfer");
        String jfUid = JSONObject.parseObject(transfer).getString("jfUid");
        HashMap<String, String> paramMap = new HashMap<>();

        paramMap.put("integrals",authParams.get("credits"));
        paramMap.put("uid",jfUid);
        paramMap.put("timestamp",String.valueOf(System.currentTimeMillis()/1000));
        Map<String,String> all_params = SignToolJSONObject.getMapToString(fudeConfig.getAppSecret(),paramMap);
        String string_to_sign = SignToolJSONObject.stringToSign(all_params);
        String signedStr =SignToolJSONObject.getMD5SignedString(string_to_sign);
        paramMap.put("sign",signedStr);

        HashMap<String, Object> param = new HashMap<>();

        param.put("param",paramMap);
        return paramMap;


    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        log.info("福德人寿获取兑换结果通知");
        return null;
    }
}
