package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.HnConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.hn.HnAopCommonParam;
import cn.com.duiba.thirdparty.dto.SupplierResponseDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.hn.HmacSha;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;

/**
 * 湖南联通支持
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/6/4 13:31
 */
@Component
public class HuNanLianTongApi implements ApiStrategy {
    public static final Logger LOGGER = LoggerFactory.getLogger(HuNanLianTongApi.class);

    private static final String SUCCESS_MSG = "湖南联通虚拟商品发放成功";
    private static final String ERROR_MSG = "发放失败，请联系客服处理";

    @Autowired
    private HnConstants hnConstants;

    @PostConstruct
    private void init() {
        ApiStrategyRouter.register(hnConstants.getAppIds(), this);
    }


    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest supplierRequestDto) {
        try {
            String url = supplierRequestDto.getHttpUrl();
            String newUrl = url.substring(0, url.indexOf('?'));
            String queryString = url.substring(newUrl.length() + 1);
            // 1.将请求URL的参数转换为MAP
            Map<String, String> params = AssembleTool.getUrlParams(queryString);

            String bizParams = Optional.ofNullable(params.get("params"))
                    .map(s -> {
                        try {
                            return URLDecoder.decode(s, "utf-8");
                        } catch (UnsupportedEncodingException e) {
                            return s;
                        }
                    })
                    .orElseThrow(() -> new BizException("湖南联通虚拟商品发放,虚拟商品编码未配置"));

            Map<String, String> config = Optional.ofNullable(hnConstants.getConfigMap().get(bizParams)).
                    orElseThrow(() -> new BizException("湖南联通虚拟商品发放,虚拟商品编码配置未找到"));

            String orderId = supplierRequestDto.getOrderId();
            String account = params.get("uid");

            LOGGER.info("湖南联通虚拟商品发放,请求参数SupplierRequestDto[{}]", JSON.toJSONString(supplierRequestDto));

            return getHttpRequestBase(config, orderId, account);
        } catch (Exception e) {
            LOGGER.warn("湖南联通虚拟商品发放失败, supplierRequestDto={}", JSON.toJSONString(supplierRequestDto), e);
        }
        return null;
    }

    @NotNull
    private HttpRequestBase getHttpRequestBase(Map<String, String> config, String orderId, String account) throws Exception {
        HnAopCommonParam reqParam = new HnAopCommonParam();
        reqParam.setMethod("ABILITY_10004414");
        reqParam.setFormat("json");
        reqParam.setAppId("501367");
        reqParam.setOperId("1");
        reqParam.setAccessToken("58d238d7-45ff-4f02-bc94-6cd93c5fff2c");
        reqParam.setBusiSerial(orderId);
        reqParam.setVersion("1");
        reqParam.setOpenId("1");
        reqParam.setRegionId(hnConstants.getRegionId());

        Map<String, Object> content = Maps.newHashMap();
        TreeMap<String, String> header = Maps.newTreeMap();
        header.put("source", "lalianwangluo");
        header.put("principal", "A0WXZC");
        header.put("transId", orderId);
        header.put("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String stringTmp = Joiner.on('&').useForNull("").withKeyValueSeparator("=").join(header);
        String token = stringTmp + "&" + hnConstants.getSignKey();
        header.put("token", DigestUtils.md5Hex(token).toLowerCase());
        content.put("head", header);

        Map<String, Object> body = Maps.newHashMap();
        Map<String, String> smsInfo = Maps.newHashMap();
        smsInfo.put("sms_content", config.get("smsContent"));
        smsInfo.put("sms_type", "2");
        body.put("smsInfo", smsInfo);
        body.put("orderId", orderId);
        body.put("isSynRedis", "0");
        body.put("benefitType", config.get("benefitType"));
        body.put("fee", "0");
        body.put("isSendSms", "1");
        body.put("beneficiary", account);
        body.put("touchType", "99");
        body.put("triggerType", "05");
        List<Map<String, String>> rights = Lists.newArrayList();
        Map<String, String> right = Maps.newHashMap();
        right.put("benefitId", config.get("benefitId"));
        right.put("right_type", "3");
        rights.add(right);
        body.put("rights", rights);
        content.put("body", body);
        reqParam.setContent(JSON.toJSONString(content));
        reqParam.setSignKey(hnConstants.getAppKey());

        reqParam.setHnaopAddress(hnConstants.getHnaopAddress());
        LOGGER.info("湖南联通虚拟商品发放,reqParam[{}]", JSON.toJSONString(reqParam));
        return sendRequest(reqParam);
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        LOGGER.info("湖南联通虚拟商品发放,响应结果,body={}", body);
        JSONObject response = JSON.parseObject(body);
        if (response == null) {
            LOGGER.warn("湖南联通虚拟商品发放,响应失败,body={}", body);
            return buildResponse(request, ERROR_MSG, SupplierResponseDto.CALLBACK_TYPE_FAILED);
        }

        String respCode = response.getString("respCode");
        String respDesc = response.getString("respDesc");
        if (!Objects.equals("00000", respCode)) {
            LOGGER.warn("湖南联通虚拟商品发放,响应失败,body={}", body);
            String msg;
            if (StringUtils.isNotBlank(respDesc)) {
                msg = new String(respDesc.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            } else {
                msg = ERROR_MSG;
            }
            return buildResponse(request, msg, SupplierResponseDto.CALLBACK_TYPE_FAILED);
        }

        JSONObject bodyObject = Optional.ofNullable(response.getJSONObject("result"))
                .map(jsonObject -> jsonObject.getJSONObject("body"))
                .orElse(new JSONObject());

        String rspCode = bodyObject.getString("rspCode");
        String rspDesc = bodyObject.getString("rspDesc");

        if (Objects.equals("0000", rspCode)) {
            return buildResponse(request, SUCCESS_MSG, SupplierResponseDto.CALLBACK_TYPE_COMPLETED);
        } else {
            LOGGER.warn("湖南联通虚拟商品发放,响应失败,body={}", body);
            String msg;
            if (StringUtils.isNotBlank(rspCode)) {
                msg = "开发者响应错误码:" + rspCode;
            } else {
                msg = ERROR_MSG;
            }
            return buildResponse(request, msg, SupplierResponseDto.CALLBACK_TYPE_FAILED);
        }
    }

    private String buildResponse(SupplierRequest requestDto, String errorMessage, String callbackType) {
        Map<String, String> params = new HashMap<>(1);
        if (SupplierResponseDto.CALLBACK_TYPE_COMPLETED.equals(callbackType)) {
            params.put("status", "success");
        } else {
            params.put("status", "fail");
            params.put("errorMessage", errorMessage);
        }
        return JSON.toJSONString(params);
    }


    private static HttpRequestBase sendRequest(HnAopCommonParam reqParam) throws Exception {
        HttpRequestBase reusultStr = null;

        try {
            SimpleDateFormat df_stamp = new SimpleDateFormat("yyyyMMddHHmmss");
            String timestampNow = df_stamp.format(new Date());
            Map<String, String> param = new HashMap();
            if (reqParam == null) {
                throw new Exception("请求参数不可为空！");
            } else if (reqParam.getMethod() == null) {
                throw new Exception("能力编码method不可为空！");
            } else if (reqParam.getFormat() == null) {
                throw new Exception("业务参数格式format不可为空！");
            } else if (reqParam.getBusiSerial() == null) {
                throw new Exception("业务流水busiSerial不可为空！");
            } else if (reqParam.getAppId() == null) {
                throw new Exception("应用者编码appId不可为空！");
            } else if (reqParam.getOperId() == null) {
                throw new Exception("操作者编码operId不可为空！");
            } else if (reqParam.getRegionId() == null) {
                throw new Exception("路由编码RegionId不可为空！");
            } else if (reqParam.getContent() == null) {
                throw new Exception("业务请求参数content不可为空！");
            } else if (reqParam.getHnaopAddress() == null) {
                throw new Exception("请求地址hnaopAddress不可为空！");
            } else {
                String hnaopAddress = reqParam.getHnaopAddress();
                param.put("method", reqParam.getMethod());
                param.put("format", reqParam.getFormat());
                param.put("busiSerial", reqParam.getBusiSerial());
                param.put("appId", reqParam.getAppId());
                param.put("operId", reqParam.getOperId());
                param.put("timestamp", timestampNow);
                param.put("openId", reqParam.getOpenId());
                param.put("accessToken", reqParam.getAccessToken());
                param.put("version", reqParam.getVersion());
                param.put("RegionId", reqParam.getRegionId());
                param.put("content", reqParam.getContent());
                String signKey = reqParam.getSignKey();
                List<String> keys = new ArrayList(param.keySet());
                Collections.sort(keys);
                String prestr = signKey;

                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String) keys.get(i);
                    String value = (String) param.get(key);
                    prestr = prestr + key + value;
                }

                prestr = prestr + signKey;
                param.put("sign", HmacSha.encryptHMAC(prestr, signKey));
                param.put("postEntityString", reqParam.getContent());
                param.remove("content");

                reusultStr = doPost("10000", hnaopAddress, "utf-8", param);
                return reusultStr;
            }
        } catch (Exception var12) {
            var12.printStackTrace();
            throw var12;
        }
    }

    public static HttpPost doPost(String idCode, String url, String charset, Map<String, String> dataMap) throws Exception {


        String paramStr = "";
        String postStr = "";
        String urlStr = "";
        String key;
        Iterator var11;
        if (idCode != null && !"".equals(idCode) && idCode.equalsIgnoreCase("10000")) {
            if (!dataMap.containsKey("postEntityString")) {
                throw new Exception("key值为postEntityString的消息体不能为空");
            }

            postStr = (String) dataMap.get("postEntityString");
            dataMap.remove("postEntityString");
            if (dataMap != null && !dataMap.isEmpty()) {
                for (var11 = dataMap.keySet().iterator(); var11.hasNext(); paramStr = paramStr + "&" + key + "=" + ((String) dataMap.get(key)).trim()) {
                    key = (String) var11.next();
                }
            }
        } else {
            if (dataMap != null && !dataMap.isEmpty()) {
                for (var11 = dataMap.keySet().iterator(); var11.hasNext(); postStr = postStr + "&" + key + "=" + ((String) dataMap.get(key)).trim()) {
                    key = (String) var11.next();
                }
            }

            if (postStr != null && !"".equals(postStr) && postStr.length() > 1) {
                postStr = postStr.substring(1);
            }
        }

        if (url == null || "".equals(url)) {
            throw new Exception("请求url不可为空");
        }

        if (url.indexOf("?") == -1) {
            if (paramStr != null && !"".equals(paramStr) && paramStr.length() > 1) {
                paramStr = paramStr.substring(1);
                urlStr = url + "?" + paramStr;
            } else {
                urlStr = url;
            }
        } else {
            urlStr = url + paramStr;
        }


        return doPost(charset, postStr, urlStr);
    }

    private static HttpPost doPost(String charset, String postStr, String urlStr) throws IOException {

        HttpPost httpPost = new HttpPost(urlStr);
        httpPost.setConfig(RequestConfig.custom().
                setSocketTimeout(60000).
                setConnectionRequestTimeout(100).
                build());

        httpPost.setHeader("accept", "*/*");
        httpPost.setHeader("connection", "Keep-Alive");
        httpPost.setHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) ...");

        StringEntity stringEntity = new StringEntity(postStr, charset);
        stringEntity.setContentEncoding(charset);
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);


        return httpPost;
    }
}
