package cn.com.duiba.config;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Configuration
@ConfigurationProperties(prefix = "order.status.push")
public class OrderStatusPushConfig implements InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderStatusPushConfig.class);
    private String configStr = "[{\"appIds\":[18705,1],\"pushUrl\":\"http://127.0.0.1:7855/taw/alipay/orderNotify\",\"perm\":1}]";


    private Map<Long, OrderStatusPushBean> configMap;

    public String getConfigStr() {
        return configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, OrderStatusPushBean> getConfigMap() {
        return configMap;
    }

    public void setConfigMap(Map<Long, OrderStatusPushBean> configMap) {
        this.configMap = configMap;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank(configStr)) {
                configMap = new HashMap<>();
                List<OrderStatusPushBean> configList = JSON.parseArray(configStr, OrderStatusPushBean.class);
                for (OrderStatusPushBean bean : configList) {
                    for (Long appId : bean.getAppIds()) {
                        OrderStatusPushBean oldvalue = configMap.put(appId, bean);
                        if (oldvalue != null) {
                            LOGGER.warn("订单推送有重复配置");
                        }
                    }
                }
            }
            LOGGER.info("订单推送配置信息:{}", JSON.toJSONString(configMap));
        } catch (Exception e) {
            LOGGER.warn("订单推送配置初始化失败，configStr={}", configStr);
        }
    }

    public static class OrderStatusPushBean {
        private List<Long> appIds;

        private String pushUrl;

        private Long perm;

        public List<Long> getAppIds() {
            return appIds;
        }

        public void setAppIds(List<Long> appIds) {
            this.appIds = appIds;
        }

        public String getPushUrl() {
            return pushUrl;
        }

        public void setPushUrl(String pushUrl) {
            this.pushUrl = pushUrl;
        }

        public Long getPerm() {
            return perm;
        }

        public void setPerm(Long perm) {
            this.perm = perm;
        }
    }

}
