package cn.com.duiba.constant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;


/**
 * @Auther: dingshitai
 * @Date: 2021/7/19 15:27
 * @Description:
 */
@Configuration
@ConfigurationProperties(prefix = "bilibili")
public class BiliBiliConfig implements InitializingBean {

    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(BiliBiliConfig.class);

    /**
     * 秘钥
     */
    private String secretKey = "96b9422ea3f04a919f4af20f9f574bdb";

    /**
     * 商户号
     */
    private String mid = "11077";


    /**
     * 卡券订购的请求地址（http://interface.kedang.net:8080/fenxiao-if/General/movies）
     */
    private String submitOrderUrl = "http://interface.kedang.net:8080/fenxiao-if/General/movies";

    /**
     * BiliBili回调通知地址()
     */
    private String notifyUrl = "http://activity.m.duiba.com.cn/taw/callbackFromBiliBili";

    @Override
    public void afterPropertiesSet() throws Exception {
    }


    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getMid() {
        return mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getSubmitOrderUrl() {
        return submitOrderUrl;
    }

    public void setSubmitOrderUrl(String submitOrderUrl) {
        this.submitOrderUrl = submitOrderUrl;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}
