package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.DisuApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author jdt
 * @date 2021-08-10
 */
@Configuration
@ConfigurationProperties(prefix = "disu")
public class DisuConfig implements InitializingBean {

    @Autowired
    private DisuApiStrategy disuApiStrategy;

    private Set<Long> appIds = Sets.newHashSet(19493L,85337L);

    private String appKey = "oK0s4H9Y";
    private String appSecret = "49a145f19d024532a6cd59e2bf9010e3";
    private String entMicroSignal = "gh_8de7e960be3a";

    private String domain = "https://hope.demogic.com/open-api";
    private String tokenUrl = "/user/getToken.json";
    //变更会员积分
    private String integralChangeUrl = "/integralChange.json";
    //查询会员余额
    private String integralBalanceUrl = "/integralBalance.json";
    private String factoryCode = "dzzit";

    private int addCreditsType = 1;
    private int addCreditsChangeType = 111;

    private int subCreditsType = 0;
    private int subCreditsChangeType = 205;

    public String getIntegralBalanceUrl() {
        return integralBalanceUrl;
    }

    public void setIntegralBalanceUrl(String integralBalanceUrl) {
        this.integralBalanceUrl = integralBalanceUrl;
    }

    public String getTokenUrl() {
        return tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getEntMicroSignal() {
        return entMicroSignal;
    }

    public void setEntMicroSignal(String entMicroSignal) {
        this.entMicroSignal = entMicroSignal;
    }

    public int getAddCreditsType() {
        return addCreditsType;
    }

    public void setAddCreditsType(int addCreditsType) {
        this.addCreditsType = addCreditsType;
    }

    public int getAddCreditsChangeType() {
        return addCreditsChangeType;
    }

    public void setAddCreditsChangeType(int addCreditsChangeType) {
        this.addCreditsChangeType = addCreditsChangeType;
    }

    public int getSubCreditsType() {
        return subCreditsType;
    }

    public void setSubCreditsType(int subCreditsType) {
        this.subCreditsType = subCreditsType;
    }

    public int getSubCreditsChangeType() {
        return subCreditsChangeType;
    }

    public void setSubCreditsChangeType(int subCreditsChangeType) {
        this.subCreditsChangeType = subCreditsChangeType;
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getIntegralChangeUrl() {
        return integralChangeUrl;
    }

    public void setIntegralChangeUrl(String integralChangeUrl) {
        this.integralChangeUrl = integralChangeUrl;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(appIds, disuApiStrategy);
    }
}
