package cn.com.duiba.constant.hsbc;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;

/**
 * @author fja
 * @date 2021-12-24
 */
@Deprecated
public class HsbcCertInitializer implements CommandLineRunner {

    private final static String JWT_RSA_PRIVATE_KEY_PATH = "/hsbc/rsa_private_key_pkcs8_uat.pem";

    private final File jwtPrivateKeyFile = new File("hsbc/rsa_private_key_pkcs8_uat_cp.pem");

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void run(String... args) throws Exception {
        InputStream inputStream = HsbcCertInitializer.class.getResourceAsStream(JWT_RSA_PRIVATE_KEY_PATH);
        if(Objects.isNull(inputStream)) {
            log.info("[hsbc]获取证书异常");
            return;
        }
        FileUtils.copyInputStreamToFile(inputStream, jwtPrivateKeyFile);

        log.info("[hsbc]jwtPrivateKeyFile初始化成功……");
    }

    public File getJwtPrivateKeyFile() {
        return jwtPrivateKeyFile;
    }
}
