package cn.com.duiba.constant.livat;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by fangdong on 2020/07/09
 */
@Configuration
@ConfigurationProperties(prefix = "livat")
public class LivatConstant implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivatConstant.class);

    private Set<Long> appId = Sets.newHashSet();

    private String vipInfoApiUrl = "https://openapi10.mallcoo.cn/User/AdvancedInfo/v1/GetMemberInfo/ByMobile/";

    private String creditsAddUrl = "https://openapi10.mallcoo.cn/User/Score/v1/Plus/ByMobile/";

    /*private String developerAppId = "5f0e74bc4ba1f21d2cd452af";

    private String developerPublicKey = "5UOErf";

    private String developerPrivateKey = "cd007c6405f874df";*/

    /**
     * 配置map的json串
     */
    private String config = "[{\"appId\":76025,\"developerAppId\":\"5f0d8e504bae7051c88ad953\",\"developerPublicKey\":\"-Ham7p\",\"developerPrivateKey\":\"152fe116c89bc527\"},{\"appId\":78198,\"developerAppId\":\"5f64643b4ba1f23bb875c1d0\",\"developerPublicKey\":\"zkQMJB\",\"developerPrivateKey\":\"b0eb52550c31fc6c\"}]";


    /**
     * 根据免登配置map解析的配置Map
     */
    private Map<Long,LivatConfig> configParamsMap = Maps.newHashMap();


    @Override
    public void afterPropertiesSet() {
        if(StringUtils.isBlank(config)){
            return;
        }
        try {
            List<LivatConfig> clientConfigs = JSONObject.parseArray(config, LivatConfig.class);
            if (CollectionUtils.isNotEmpty(clientConfigs)) {
                configParamsMap = clientConfigs.stream().collect(Collectors.toMap(LivatConfig::getAppId, f -> f));
                appId = clientConfigs.stream().map(LivatConfig::getAppId).collect(Collectors.toSet());
            }
        } catch (Exception e) {
            LOGGER.error("荟聚中心配置错误",e);
        }

    }

    public String getCreditsAddUrl() {
        return creditsAddUrl;
    }

    public Set<Long> getAppId() {
        return appId;
    }

    public void setAppId(Set<Long> appId) {
        this.appId = appId;
    }

    public String getVipInfoApiUrl() {
        return vipInfoApiUrl;
    }

    public void setVipInfoApiUrl(String vipInfoApiUrl) {
        this.vipInfoApiUrl = vipInfoApiUrl;
    }

    public void setCreditsAddUrl(String creditsAddUrl) {
        this.creditsAddUrl = creditsAddUrl;
    }

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Map<Long, LivatConfig> getConfigParamsMap() {
        return configParamsMap;
    }

    public void setConfigParamsMap(Map<Long, LivatConfig> configParamsMap) {
        this.configParamsMap = configParamsMap;
    }
}
