package cn.com.duiba.crecord.message;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.thirdparty.dto.HttpResponseMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 定制的兑换记录同步第三方
 */
@Service
public class CrecordAsyncHttp {

	private static Logger logger = LoggerFactory.getLogger(CrecordAsyncHttp.class);

	@Autowired
	private HttpRetryRulesService httpRetryRulesService;
	@Autowired
	private AppDAO appDAO;
	@Autowired
	private HttpMessageDAO httpMessageDAO;
	@Autowired
	private ThreadPoolService threadPoolService;
	@Autowired
	private NotifyHttpClientPool notifyHttpClientPool;

	@Autowired
	private CustomService customService;


	/**
	 * 提交兑换记录通知同步请求
	 *
	 * @param message
	 */
	public void asyncSubmit(final String message) {
		final HttpRequestMessageDto dto = JSONObject.parseObject(message, HttpRequestMessageDto.class);

		AppDO app = appDAO.findAppSimple(dto.getAppId());
		if (app == null) {
			logger.warn("appId:{} recordNotifyUrl: is empty", dto.getAppId());
			return;
		}

		if(StringUtils.isEmpty(app.getRecordNotifyUrl()) && !customService.isZHBApp(app.getId())
		&& (ApiStrategyRouter.route(app.getId()) == null || !ApiStrategyRouter.route(app.getId()).isCustomCrecord(dto))){
			logger.warn("appId:{} recordNotifyUrl: is empty", dto.getAppId());
			return;
		}

		HttpMessageDO hmd = new HttpMessageDO();
		hmd.setAppId(dto.getAppId());
		hmd.setBizType(dto.getBizType());
		hmd.setBizParams(JSONObject.toJSONString(dto.getHttpParams()));
		hmd.setNumber(0);
		hmd.setOffset(httpRetryRulesService.getNextSecond(hmd));
		httpMessageDAO.insert(hmd);

		asyncSubmit(hmd, dto, app);
	}

	/**
	 * 提交HTTP请求
	 *
	 * @param db
	 * @param msg
	 * @param app
	 */
	public void asyncSubmit(final HttpMessageDO db, final HttpRequestMessageDto msg, AppDO app) {
		if (app==null) {
			return;
		}
		HttpRequestBase http = customService.getCrecordHttpRequest(msg, app);
		String url;
		if(http == null){
			Map<String, String> map = msg.getHttpParams();
			if (MapUtils.isEmpty(map)) {
				logger.info("[action crecord]appid = {} getHttpParams is empty",app.getId());
				return;
			}
			map.put("appKey", app.getAppKey());
			map.put("appSecret", appDAO.getAppSecret(app));
			String sign = SignTool.sign(map);
			map.put("sign", sign);
			map.remove("appSecret");
			if (StringUtils.isEmpty(app.getRecordNotifyUrl())) {
				logger.info("[action crecord] appid = {} getRecordNotifyUrl is empty",app.getId());
				return;
			}
			url = AssembleTool.assembleUrl(app.getRecordNotifyUrl(), map);
			http = new HttpGet(url.trim());
			HttpRequestLog.logUrl("[action crecord] [tag get request] [url " + url + "]");
		}else{
			url = http.getURI().toString();
		}
		submitReq(msg, http, db, url);
	}


	private void submitReq(HttpRequestMessageDto msg, HttpRequestBase http,HttpMessageDO db,String url) {

		notifyHttpClientPool.submit(msg.getAppId(), http, new FutureCallback<HttpResponse>() {

			@Override
			public void completed(HttpResponse response) {
				HttpResponseMessageDto resp = new HttpResponseMessageDto();
				try {
					resp.setCallbackType(HttpResponseMessageDto.CALLBACK_TYPE_COMPLETED);
					resp.setHttpUrl(url);
					Header header = response.getEntity().getContentEncoding();
					String body;
					if(header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)){
						body = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
					}else{
						body = EntityUtils.toString(response.getEntity());
					}
					//解析定制响应
					body = customService.getCrecordResponse(body,msg.getAppId());
					if (StringUtils.isNotEmpty(body)) {
						String cont = body.toLowerCase();
						if (cont.contains("ok")) {
							resp.setSuccess(true);
						}
					}
					resp.setBody(HttpRequestLog.subBody(body));
					resp.setBizId(msg.getBizId());
					resp.setBizType(msg.getBizType());
				} catch (Exception e) {
					resp.setSuccess(false);
					resp.setErrorMessage("请求失败:completed:" + e.getMessage());
					logger.error("completed param: {}", getCrecordParam(msg), e);
				} finally {
					httpRequestComleted(db, msg, resp);
				}
			}

			@Override
			public void failed(Exception ex) {
				logger.warn("crecord failed param: {}, errMsg: {}", getCrecordParam(msg), getErrorMsg(ex),ex);

				HttpResponseMessageDto resp = new HttpResponseMessageDto();
				resp.setCallbackType(HttpResponseMessageDto.CALLBACK_TYPE_FAILED);
				resp.setHttpUrl(url);
				resp.setBizId(msg.getBizId());
				resp.setBizType(msg.getBizType());
				resp.setSuccess(false);
				resp.setErrorMessage("请求失败:failed:" + ex.getMessage());
				httpRequestComleted(db, msg, resp);
			}

			@Override
			public void cancelled() {
				logger.warn("crecord failed param:" + getCrecordParam(msg));
				HttpResponseMessageDto resp = new HttpResponseMessageDto();
				resp.setCallbackType(HttpResponseMessageDto.CALLBACK_TYPE_CANCELLED);
				resp.setHttpUrl(url);
				resp.setBizId(msg.getBizId());
				resp.setBizType(msg.getBizType());
				resp.setSuccess(false);
				resp.setErrorMessage("请求失败:cancelled");
				httpRequestComleted(db, msg, resp);
			}

		});
	}

	private String getErrorMsg(Exception ex) {
		String errMsg = ex.getMessage();
		if(ex.getCause() != null){
            errMsg = ex.getCause().getMessage();
        }
		return errMsg;
	}

	private String getCrecordParam(HttpRequestMessageDto msg) {
		return msg.getHttpParams() != null ? JSONObject.toJSONString(msg.getHttpParams()) : "null";
	}

	private String getCrecordId(HttpRequestMessageDto msg) {
		Map<String, String> map = msg.getHttpParams();
		if(MapUtils.isEmpty(map)){
			return "";
		}

		return map.get("recordId");
	}

	/**
	 * httpRequestComleted
	 *
	 * @param db
	 * @param resp
	 */
	private void httpRequestComleted(final HttpMessageDO db, HttpRequestMessageDto requestMessageDto, final HttpResponseMessageDto resp) {
		HttpRequestLog.logUrl("[action crecord Response][callback " + resp.getCallbackType() + "] [body " + resp.getBody() + "][recordId " + getCrecordId(requestMessageDto) + "]");
		threadPoolService.submit(new Runnable() {
			@Override
			public void run() {
				try {
					if (!HttpResponseMessageDto.CALLBACK_TYPE_COMPLETED.equals(resp.getCallbackType()) || !"ok".equalsIgnoreCase(resp.getBody())) {
						if (db.getNumber() >= httpRetryRulesService.getRetryNumber(db)) {
							httpMessageDAO.delete(db.getId());
							return;
						}
						httpMessageDAO.updateNextTime(db.getId(), httpRetryRulesService.getNextSecond(db));
						return;
					}
					httpMessageDAO.delete(db.getId());
				} catch (Exception e) {
					logger.error("httpRequestComleted", e);
				}
			}
		});

	}

}
