package cn.com.duiba.dto.sn;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

public class SnbRequestParam {

    // 加载商户秘钥 商户秘钥路径 自定更改
    public static String AppCode;
    public static String ChannelId; // 渠道号,由行方分配
    public PayLoadParam payLoad; // 业务数据

    @Length(max = 30,  message = "channelSerialNo 最大30位")
    @NotBlank(message = "channelSerialNo 不能为空")
    private String channelSerialNo;

    @Length(max = 40,  message = "transCode 最大40位")
    @NotBlank(message = "transCode 不能为空")
    private String transCode;

    @Length(max = 30,  message = "deviceId 最大30位")
    private String deviceId;

    @Length(max = 10,  message = "terminal 最大10位")
    private String terminal;

    @Length(max = 50,  message = "gps 最大50位")
    private String gps;

    @Length(max = 50,  message = "ipAddress 最大50位")
    private String ipAddress;

    @Length(max = 50,  message = "macAddress 最大50位")
    private String macAddress;

    @Length(max = 20,  message = "osVersion 最大20位")
    private String osVersion;

    @Length(max = 64,  message = "openId 最大64位")
    private String openId;

    public static String getAppCode() {
        return AppCode;
    }

    public static void setAppCode(String appCode) {
        AppCode = appCode;
    }

    public static String getChannelId() {
        return ChannelId;
    }

    public static void setChannelId(String channelId) {
        ChannelId = channelId;
    }

    public String getChannelSerialNo() {
        return channelSerialNo;
    }

    public void setChannelSerialNo(String channelSerialNo) { this.channelSerialNo = channelSerialNo; }

    public String getTransCode() {
        return transCode;
    }

    public void setTransCode(String transCode) {
        this.transCode = transCode;
    }

    public PayLoadParam getPayLoad() { return payLoad;}

    public void setPayLoad(PayLoadParam payLoad) { this.payLoad = payLoad; }

    public String getDeviceId() { return deviceId;}

    public void setDeviceId(String deviceId) { this.deviceId = deviceId; }

    public String getTerminal() { return terminal;}

    public void setTerminal(String terminal) { this.terminal = terminal; }

    public String getGps() { return gps; }

    public void setGps(String gps) { this.gps = gps; }

    public String getIpAddress() { return ipAddress; }

    public void setIpAddress(String ipAddress) { this.ipAddress = ipAddress; }

    public String getMacAddress() {return macAddress; }

    public void setMacAddress(String macAddress) { this.macAddress = macAddress; }

    public String getOsVersion() { return osVersion; }

    public void setOsVersion(String osVersion) { this.osVersion = osVersion; }

    public String getOpenId() { return openId;}

    public void setOpenId(String openId) { this.openId = openId; }
}
