package cn.com.duiba.enums.icbcelife;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

public enum HandlerMannerEnum {
    RETRY(1,"继续重试"),
    END(2,"结束，删除记录"),
    EXECUTE(3,"继续执行"),
    ;

    private int type;
    private String desc;

    private static final ImmutableMap<Integer, HandlerMannerEnum> ALL_MAPPING;

    static {
        Map<Integer, HandlerMannerEnum> temp = Maps.newHashMap();
        for (HandlerMannerEnum value : values()) {
            temp.put(value.type, value);
        }
        ALL_MAPPING = ImmutableMap.copyOf(temp);
    }

    @CheckForNull
    public static HandlerMannerEnum getByType(int type) {
        return ALL_MAPPING.get(type);
    }

    HandlerMannerEnum(int type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

}
