package cn.com.duiba.mq.dinghandler;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 钉钉消息上线文处理类
 * Created by sunchangji on 2018/11/14.
 */
@Component
public class SendDingMsgHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SendDingMsgHelper.class);

    private static Map<String,SendDingMsgTagIHandler> tagAndTagHandlers = new HashMap<>();

    public static void registerTagHandler(SendDingMsgTagIHandler handler){
        if(handler == null){
            LOG.warn("registerTagHandler SendDingMsgTagIHandler is null");
            return;
        }
        tagAndTagHandlers.put(handler.getTag(),handler);
    }

    /**
     * 根据tag选择消息处理器
     *
     * @param message
     * @return
     */
    public boolean handleMqMessage(MessageExt message){
        String tag = message.getTags();
        String topic = message.getTopic();
        if(StringUtils.isEmpty(tag)){
            LOG.warn("SendDingMsg handleMqMessage tag is null,topic={}",topic);
            return false;
        }
        SendDingMsgTagIHandler tagHandler = tagAndTagHandlers.get(tag);
        if(tagHandler == null){
            LOG.warn("SendDingMsg handleMqMessage topic={},tag={}无对应的tag消息处理器",topic,tag);
            return false;
        }
        byte[] mqMsg = message.getBody();
        if(mqMsg == null){
            LOG.warn("SendDingMsg handleMqMessage topic={},tag={},Mq消息内容为空",topic,tag);
            return false;
        }
        return tagHandler.handleMQMessage(mqMsg);
    }
}
