package cn.com.duiba.remoteimpl.hsbc;

import cn.com.duiba.biz.credits.strategy.Impl.HsbcApiStrategy;
import cn.com.duiba.thirdparty.api.hsbc.RemoteHsbcBankServcie;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcPointTask;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusQuery;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusRespData;
import cn.com.duiba.thirdparty.dto.hsbc.UserInfoDto;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author haojiahong
 * @date 2021-12-27
 */
@RestController
public class RemoteHsbcBankServcieImpl implements RemoteHsbcBankServcie {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHsbcBankServcieImpl.class);

    @Autowired
    private HsbcApiStrategy hsbcApiStrategy;

    @Override
    public UserInfoDto getUserInfo(String hsbcOpenId, String hsbcAppId, Long duibaAppId) {
        if (StringUtils.isBlank(hsbcOpenId) || StringUtils.isBlank(hsbcAppId)) {
            LOGGER.warn("获取汇丰用户信息，参数有误，hsbcOpenId={} hsbcAppId={}", hsbcOpenId, hsbcAppId);
            return null;
        }
        UserInfoDto userInfoDto = hsbcApiStrategy.getUserInfo(hsbcOpenId, hsbcAppId, duibaAppId);
        return userInfoDto;
    }

    @Override
    public List<HsbcPointTask> queryTaskList(Long duibaAppId) {
        if(Objects.isNull(duibaAppId)) {
            return Collections.emptyList();
        }

        return hsbcApiStrategy.queryPointTaskList(duibaAppId);
    }

    @Override
    public TaskStatusRespData doTaskStatusQuery(TaskStatusQuery queryParams) {
        //校验
        if(StringUtils.isBlank(queryParams.getPartnerUserId()) || Objects.isNull(queryParams.getDuibaAppId())) {
            throw new IllegalArgumentException(String.format("[hsbc]参数异常 queryParams = %s", JSON.toJSONString(queryParams)));
        }

        return hsbcApiStrategy.doTaskStatusQuery(queryParams);
    }

}
