package cn.com.duiba.service;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhangruofan
 * @date 2019/02/15
 */
@Component
public class DuibaVirtualManager implements InitializingBean {

    private static final Map<String, DuibaVirtualSupplier> MAP = new HashMap<>();
    @Autowired
    private List<DuibaVirtualSupplier> supplierList;

    public DuibaVirtualSupplier getSupplier(String virtualTypeCode) {
        if (StringUtils.isBlank(virtualTypeCode)) {
            return null;
        }
        return MAP.get(virtualTypeCode);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        for (DuibaVirtualSupplier supplier : supplierList) {
            MAP.put(supplier.getVirtualTypeCode(), supplier);
        }
    }
}
