package cn.com.duiba.service;

import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.ExecutorService;

/**
 * 线程池公共类<br/>
 * 线程池交给spring管理，系统停机时spring根据依赖顺序关闭
 * 
 * @author houwen
 */
@Service
public class ThreadPoolService {

	@Resource
	private ExecutorService executorService;

	/**
	 * 提交异步任务
	 * 
	 * @param runnable
	 */
	public void submit(Runnable runnable) {
		executorService.execute(runnable);
	}

	/**
	 * 获取活跃线程
	 * 
	 * @return
	 */
	public int getActive() {
		return ((ThreadPoolExecutorWrapper) executorService).getActiveCount();
	}

	/**
	 * 获取最大线程数
	 * 
	 * @return
	 */
	public int getMaxThread() {
		return ((ThreadPoolExecutorWrapper) executorService).getCorePoolSize();
	}

	/**
	 * 是否能提交
	 * 
	 * @return
	 */
	public boolean canSubmit() {
		if (getActive() >= getMaxThread()) {
			return false;
		}
		return true;
	}

}
