package cn.com.duiba.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.kouweiwang.KwwConfig;
import cn.com.duiba.service.KwwOrderSyncService;
import cn.com.duiba.thirdparty.dto.kouweiwang.KwwOrderSyncDto;
import cn.com.duiba.thirdparty.dto.kouweiwang.KwwRespBodyDto;
import cn.com.duiba.tool.kouweiwang.KwwTool;
import com.alibaba.fastjson.JSON;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;

/**
 * @author fja
 */
@Service
public class KwwOrderSyncServiceImpl implements KwwOrderSyncService {

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Resource(name = "shotKeepAliveHttpClient")
    private CloseableHttpClient httpClient;

    @Resource
    private KwwTool kwwTool;

    @Resource
    private KwwConfig kwwConfig;

    private final RequestConfig config;
    private static final int THREE_SECONDS = 5 * 1000;

    {
        //http请求超时配置
        config = RequestConfig.custom().setConnectTimeout(THREE_SECONDS).setSocketTimeout(THREE_SECONDS).setConnectionRequestTimeout(500).build();
    }


    @Override
    public KwwRespBodyDto sendOrderInfo2Developer(KwwOrderSyncDto kwwOrderSyncDto) throws BizException{
        HttpPost httpPost = new HttpPost(kwwConfig.getOrderSyncUrl());
        try {
            //加密
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(kwwOrderSyncDto));
            log.info("kww订单同步 参数-未加密 = {} 加密 = {}", JSON.toJSONString(kwwOrderSyncDto), cipherText);
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);
        } catch (Exception e) {
            log.warn("kww订单同步 加密异常", e);
            throw new BizException("kww订单同步出错");
        }


        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String resp = EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8);
            if(kwwTool.isJsonString(resp)) {
                throw new IllegalArgumentException(resp);
            }

            //解密
            String syncRespData = kwwTool.aesDecrypt(resp);
            KwwRespBodyDto kwwRespBodyDto = JSON.parseObject(syncRespData, KwwRespBodyDto.class);

            if (!KwwRespBodyDto.SUCCESS.equals(kwwRespBodyDto.getResult())) {
                log.info("kww订单同步失败, order:{}, message:{}", kwwOrderSyncDto.getOrderNum(), syncRespData);
            }
            return kwwRespBodyDto;
        } catch (Exception e) {
            log.warn(String.format("kww订单 = %s 同步 发送异常", kwwOrderSyncDto.getOrderNum()), e);
            throw new BizException("kww订单同步出错");
        }
    }

    @Override
    public KwwRespBodyDto sendOrderInfo2Developer(String syncOrder) throws BizException{
        HttpPost httpPost = new HttpPost(kwwConfig.getOrderSyncUrl());
        try {
            //加密
            String cipherText = kwwTool.aesEncrypt(syncOrder);
            log.info("kww订单同步 参数-未加密 = {} 加密 = {}", syncOrder, cipherText);
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);
        } catch (Exception e) {
            log.warn("kww订单同步加密异常:{}", syncOrder, e);
            throw new BizException("kww订单同步出错");
        }


        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String resp = EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8);
            if(kwwTool.isJsonString(resp)) {
                throw new IllegalArgumentException(resp);
            }

            //解密
            String syncRespData = kwwTool.aesDecrypt(resp);
            KwwRespBodyDto kwwRespBodyDto = JSON.parseObject(syncRespData, KwwRespBodyDto.class);

            if (!KwwRespBodyDto.SUCCESS.equals(kwwRespBodyDto.getResult())) {
                log.info("kww订单同步失败, request:{}, message:{}", syncOrder, syncRespData);
            }
            return kwwRespBodyDto;
        } catch (Exception e) {
            log.warn("kww同步发送异常:{}", syncOrder, e);
            throw new BizException("kww订单同步出错");
        }
    }

    @Override
    public KwwRespBodyDto notifyResult2Developer(KwwOrderSyncDto kwwOrderSyncDto) throws BizException{
        HttpPost httpPost = new HttpPost(kwwConfig.getNotifyOrderResultUrl());
        try {
            //加密
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(kwwOrderSyncDto));
            log.info("[kww]兑换结果通知 参数-未加密 = {} 加密 = {}", JSON.toJSONString(kwwOrderSyncDto), cipherText);
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);
        } catch (Exception e) {
            log.warn("[kww]兑换结果通知 加密异常", e);
            throw new BizException("kww兑换结果通知出错");
        }

        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String resp = EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8);
            if(kwwTool.isJsonString(resp)) {
                throw new IllegalArgumentException(resp);
            }

            //解密
            String syncRespData = kwwTool.aesDecrypt(resp);
            KwwRespBodyDto kwwRespBodyDto = JSON.parseObject(syncRespData, KwwRespBodyDto.class);

            if (!KwwRespBodyDto.SUCCESS.equals(kwwRespBodyDto.getResult())) {
                log.info("kww兑换结果通知失败：order:{}, message:{}", kwwOrderSyncDto.getOrderNum(), syncRespData);
            }
            return kwwRespBodyDto;
        } catch (Exception e) {
            log.warn(String.format("kww订单 = %s 兑换结果通知 发送异常", kwwOrderSyncDto.getOrderNum()), e);
            throw new BizException("kww兑换结果通知出错");
        }
    }
}
