package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.dto.SupplierResponseDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.stereotype.Service;

/**
 *
 * 成功的api的策略 mock代码
 *
 * @author zouweixiang
 * @date 2021/07/27
**/
@Service
public class SuccessApiStrategy extends AbstractDuibaVirtualSupplier {

    @Override
    public void submit(SupplierRequestDto request) {
        SupplierResponseDto resp = new SupplierResponseDto();
        resp.setOrderId(request.getOrderId());
        resp.setSupplierOrderId(request.getSupplierOrderId());
        resp.setSupplierName(request.getSupplierName());
        resp.setUrl(request.getHttpUrl());
        resp.setCallbackType(SupplierResponseDto.CALLBACK_TYPE_COMPLETED);
        resp.setAppId(request.getAppId());
        resp.setConsumerId(request.getConsumerId());
        super.sendResponse(resp);
    }

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.SUCCESS.getCode();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto request) {
        return null;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        return null;
    }
}
