package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class UnionPayBankUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionPayBankUtil.class);

    /**
     * 云闪付RSA签名
     */
    public static String sign(Map<String, String> param, String signKey) {
        try {
            String value = sortMap(param);
            LOGGER.info("云闪付定制签名原串为:{}", value);
            byte[] keyBytes = Base64.decodeBase64(signKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            signature.update(value.getBytes());
            byte[] signed = signature.sign();
            return Base64.encodeBase64String(signed);
        } catch (Exception e) {
            LOGGER.error("云闪付定制签名失败", e);
            throw new ThirdpatyException("云闪付定制签名失败");
        }
    }


    /**
     * 参数名按ASCII码从小到大排序（字典序）
     *
     * @return
     */
    private static String sortMap(Map<String, String> param) {
        StringBuilder result = new StringBuilder();
        Collection<String> keySet = param.keySet();
        List<String> list = new ArrayList<String>(keySet);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            if ("symmetricKey".equals(key)) {
                continue;
            }
            result.append(key).append("=").append(param.get(key)).append("&");
        }
        String sortMap = result.substring(0, result.length() - 1);
        return sortMap;
    }

    /**
     * 生成签名随机值
     *
     * @return
     */
    public static String createNonceStr() {
        String sl = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; i++) {
            sb.append(sl.charAt(new Random().nextInt(sl.length())));
        }
        return sb.toString();
    }
}
