package cn.com.duiba.tool.zhiji;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/**
 * @author: pengyi
 * @description: 智己参数构建解析工具
 * @date: 2021/9/1 下午4:30
 */
@Component
public class ZhiJiParamTool {

    private final static Logger log = LoggerFactory.getLogger(ZhiJiParamTool.class);

    private static final String MAC_NAME = "HmacSHA256";
    private static final String ENCODING = "UTF-8";
    private static final String TEST_USERNAME = "duaibauat";
    private static final String PROD_USERNAME = "duibaprod";
    private static final String TEST_ENCRYPT_KEY = "myi6MBoU8PSIXnrkC6nogKKd1yM9x1Q8";
    private static final String PROD_ENCRYPT_KEY = "dF0Watf8GszMNpsJ4jC3YG4JBxK9A7Qu";

    private static final RequestConfig requestConfig;
    private static final int FIVE_SECONDS = 5*1000;
    private static final int TEN_SECONDS = 10*1000;

    @Autowired
    private ZhiJiConfig zhiJiConfig;

    static {
        //http请求超时配置
        requestConfig = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }
    /**
     * 构建参数，创建httpPost请求
     * dto只能是对象，不能是map
     * @param dto
     * @return
     */
    public HttpPost createHttpPost(Object dto, String url, String domainName) {
        if (dto == null || StringUtils.isBlank(url)) {
            return null;
        }
        log.info("智己-post请求参数，url:{}, params:{}", url, JSON.toJSONString(dto));
        HttpPost httpPost = new HttpPost(domainName + url);
        buildHttpHeader(dto,url,httpPost);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(dto),"UTF-8"));
        httpPost.setConfig(requestConfig);
        log.info("智己-post请求参数，params:{},header:{}",JSON.toJSONString(dto), JSON.toJSONString(httpPost.getAllHeaders()));
        return httpPost;
    }

    /**
     * 构建参数，创建httpGet请求
     * @param params
     * @return
     */
    public HttpGet createHttpGet(Map<String, String> params, String url, String domainName) {
        if (params == null || StringUtils.isBlank(url)) {
            return null;
        }
        log.info("智己-get请求参数，url:{}, params:{}", url, JSON.toJSONString(params));
        StringBuilder param = new StringBuilder(domainName + url).append("?");
        List<String> paramList = new ArrayList<>();
        params.entrySet().forEach(entry -> {
            paramList.add(entry.getKey()+"="+entry.getValue());
        });
        param.append(StringUtils.join(paramList,"&"));
        HttpGet httpGet = new HttpGet(param.toString());
        String signature = buildHttpHeader(params, url, httpGet);
        if (signature == null) {
            return null;
        }
        log.info("智己-get请求参数，url:{},signature:{},header:{}", param.toString(), signature, JSON.toJSONString(httpGet.getAllHeaders()));
        httpGet.setConfig(requestConfig);
        return httpGet;
    }

    @Nullable
    public String buildHttpHeader(Object params, String url, HttpRequestBase httpRequestBase) {
        String signature;
        Calendar cd = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String datetime = sdf.format(cd.getTime());
        try {
            signature = calcAuthorization(datetime,url, httpRequestBase.getMethod());
        } catch (Exception e) {
            log.warn("智己-发送请求，参数加密失败，url:{}, param:{}", url, JSON.toJSONString(params));
            return null;
        }
        if (zhiJiConfig.getFirst() == 1) {
            httpRequestBase.setHeader(zhiJiConfig.getHmacDateKey(), datetime);
        }
        if (zhiJiConfig.getSecond() == 1) {
            httpRequestBase.setHeader(zhiJiConfig.getHmacKey(), signature);
        }
        httpRequestBase.setHeader("Content-Type","application/json;charset=utf-8");
        return signature;
    }

    /**
     * dto类转位map
     * 不为空的字段会放入map中
     * @param obj
     * @return
     * @throws IllegalAccessException
     */
    public static Map<String, String> dtoConvertParams(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        Map<String, String> params = Maps.newHashMap();
        Class clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.get(obj) != null) {
                params.put(field.getName(), String.valueOf(field.get(obj)));
            }
        }
        return params;
    }

    /**
     * hamc加密
     * 加密后byte[]需用Hex.encodeHexString(bytes)转为string
     * @param encryptText
     * @return
     */
    public static byte[] hmacEncrypt(String encryptText) {
        String encryptKey = TEST_ENCRYPT_KEY;
        if (SpringEnvironmentUtils.isProdEnv()) {
            encryptKey = PROD_ENCRYPT_KEY;
        }
        try {
            byte[] data = encryptKey.getBytes(ENCODING);
            //根据给定的字节数组构造一个密钥,第二参数指定一个密钥算法的名称
            SecretKey secretKey = new SecretKeySpec(data, MAC_NAME);
            //生成一个指定 Mac 算法 的 Mac 对象
            Mac mac = Mac.getInstance(MAC_NAME);
            //用给定密钥初始化 Mac 对象
            mac.init(secretKey);
            byte[] text = encryptText.getBytes(ENCODING);
            //完成 Mac 操作
            return mac.doFinal(text);
        } catch (Exception e) {
            log.error("智己-hmac加密失败，encryptText：{}", encryptText, e);
        }
        return null;
    }

    /**
     * 智己hamc加密
     * @param datetime
     * @param requestLine
     * @return
     * @throws NoSuchAlgorithmException
     * @throws UnsupportedEncodingException
     * @throws InvalidKeyException
     */
    public static String calcAuthorization(String datetime, String requestLine, String requestMethod) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        String secretKey = TEST_ENCRYPT_KEY;
        String secretId = TEST_USERNAME;
        if (SpringEnvironmentUtils.isProdEnv()) {
            secretKey = PROD_ENCRYPT_KEY;
            secretId = PROD_USERNAME;
        }
        String signStr = "x-date: " + datetime + "\n" + requestMethod + " "+requestLine+" HTTP/1.1";
        Mac mac = Mac.getInstance("HmacSHA256");
        Key sKey = new SecretKeySpec(secretKey.getBytes("UTF-8"), mac.getAlgorithm());
        mac.init(sKey);
        byte[] hash = mac.doFinal(signStr.getBytes("UTF-8"));
        String sig = new BASE64Encoder().encode(hash);

        String auth = "hmac username=\"" + secretId
                + "\", algorithm=\"hmac-sha256\", headers=\"x-date request-line\", signature=\"" + sig + "\"";
        log.info("智己hmac加密后，auth：{}",auth);
        return auth;
    }

    /**
     * 返回6位随机数字
     * @return
     */
    public String generateRandom() {
        return String.valueOf(RandomUtils.nextInt(100000,999999));
    }
}
