package cn.com.duiba.vo.union;

/**
 * @Description 银联红包发放配置
 * @Date 2022/3/11
 * @Author WeiChaoChao
 */
public class UnionRedConfig {
    /**
     * 开发者appId
     */
    private String appId;
    /**
     * 小程序appId
     */
    private String miniAppId;
    /**
     * 发放userId类型 1:openId 2:手机号
     */
    private String sendUserIdType;
    /**
     * 业务类型(区分不同积分类型业务的类型  兑吧方自己定义 在商品标识编码中体现)
     */
    private String businessType;
    /**
     * 机构账户代码，最大32位，对应云闪付小程序开放平台配置：营销能力包-红包接入方账户
     */
    private String insAcctId;
    /**
     * 积分 id ，最大 64 位,对应云闪付小程序开放平台配置：营销能力包-专享红包活动编码
     */
    private String pointId;
    /**
     * 有效期开始时间
     */
    private String validBeginTs;
    /**
     * 有效期截止时间
     */
    private String validEndTs;
    /**
     * 业务信息 活动 ID(确保活动Id唯一)
     */
    private String campaignId;
    /**
     * 业务信息 活动名称
     */
    private String campaignName;
    /**
     * 交易摘要，最大200位,赠送积分说明，用于前台展示
     */
    private String transDigest;
    /**
     * 备注，最大 512 位
     */
    private String remark;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMiniAppId() {
        return miniAppId;
    }

    public void setMiniAppId(String miniAppId) {
        this.miniAppId = miniAppId;
    }

    public String getSendUserIdType() {
        return sendUserIdType;
    }

    public void setSendUserIdType(String sendUserIdType) {
        this.sendUserIdType = sendUserIdType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getInsAcctId() {
        return insAcctId;
    }

    public void setInsAcctId(String insAcctId) {
        this.insAcctId = insAcctId;
    }

    public String getPointId() {
        return pointId;
    }

    public void setPointId(String pointId) {
        this.pointId = pointId;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getTransDigest() {
        return transDigest;
    }

    public void setTransDigest(String transDigest) {
        this.transDigest = transDigest;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getValidBeginTs() {
        return validBeginTs;
    }

    public void setValidBeginTs(String validBeginTs) {
        this.validBeginTs = validBeginTs;
    }

    public String getValidEndTs() {
        return validEndTs;
    }

    public void setValidEndTs(String validEndTs) {
        this.validEndTs = validEndTs;
    }
}
