package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.QqBrowserConfig;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

/**
 * @author liugq
 * @date 2019/12/10
 * @description: qq浏览器定制
 */
@Service
public class QqBrowserApi {

    private Logger logger = LoggerFactory.getLogger(QqBrowserApi.class);

    private static final String APP_KEY = "appKey";
    private static final String TIMESTAMP = "timestamp";
    private static final String INTEGRAL = "integral";
    private static final String CIPHER = "cipher";
    private static final String USER_ID = "userId";
    private static final String RESPONSE_CODE = "code";
    private static final String RESPONSE_MSG = "msg";


    @Autowired
    private QqBrowserConfig qqBrowserConfig;


    public boolean isQqBrowserApp(Long appId){
        return qqBrowserConfig.getAppIds().contains(appId);
    }


    /**
     * 组装加积分对象 正常加积分
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        try {
            String url = request.getHttpUrl();
            //post请求,截取出url去除参数的部分,设置为请求url
            String host = url.substring(0, url.indexOf('?'));
            request.setHttpUrl(host);
            //将原get请求的参数转化成map
            String params = url.substring(url.indexOf('?') + 1, url.length());
            Map<String, String> originParam = AssembleTool.getUrlParams(params);
            String appKey = qqBrowserConfig.getAppKey();
            String appSecret = qqBrowserConfig.getDuibaAppSecret();
            long timestamp = System.currentTimeMillis();
            String userId = originParam.get("uid");
            String integral = originParam.get("credits");
            String cipher = MD5.md5(appKey + appSecret + timestamp + userId + integral);
            Map<String, String> authParams = Maps.newHashMap();
            authParams.put(USER_ID, userId);
            authParams.put(APP_KEY, appKey);
            authParams.put(INTEGRAL, integral);
            authParams.put(TIMESTAMP, String.valueOf(timestamp));
            authParams.put(CIPHER, cipher);
            request.setAuthParams(authParams);
            request.setHttpType(CreditsMessage.HTTP_POST);
            return request;
        } catch (Exception ex) {
            logger.info("getAddCreditsMessage call getSubCreditsMessage error , request = {}", JSONObject.toJSONString(request), ex);
            throw new BizException("qq浏览器加积分流程中断");
        }
    }

    /**
     * 加积分返回处理
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        JSONObject responseBody;
        try {
            responseBody = JSON.parseObject(body);
        } catch (Exception e) {
            logger.error("JSON.parseObject:", e);
            return body;
        }
        Map<String, String> duibaDoc = Maps.newHashMap();
        if (Objects.equals(responseBody.getInteger(RESPONSE_CODE), 0)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", responseBody.getString(RESPONSE_MSG));
        }
        return JsonTool.objectToJson(duibaDoc);
    }
}
