package cn.com.duiba.biz.credits.strategy;

import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Map;

/**
 * @Date 2020/12/28
 * @Created by cmm
 * 可参考DemoApiStrategy,DemoConfig
 * {@link cn.com.duiba.biz.credits.strategy.Impl.DemoApiStrategy}
 * {@link cn.com.duiba.constant.DemoConfig}
 */
public interface ApiStrategy extends CrecordApiStrategy{

    /**
     * @param message :
     * @Description:获取扣积分http包装类
     */
    default HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message){
        return null;
    }
    /**
     * @param body       :
     * @param authParams
     * @Description:解析扣积分响应返回兑吧侧通用响应
     */
    default String parseCreditsRsp(String body,Boolean addCredits, Map<String, String> authParams){
        return null;
    }
    /**
     * @param message :
     * @Description:获取加积分http包装类
     */
    default HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message){
        return null;
    }
    /**
     * 获取兑换结果通知http包装类
     */
    default HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record){
        return null;
    }

    default String getResponseNotify(NotifyQueueDO notifyQueue, String body) {
        return null;
    }

    /**
     * 虚拟商品请求
     */
    default HttpRequestBase getVirtualRequest(SupplierRequest request) {
        return null;
    }
    /**
     * 解析虚拟商品充值响应结果
     */
    default String getVirtualResponse(SupplierRequest request, String body) {
        return null;
    }


    default Boolean appIdCheck(Long appId){
        return null;
    }

    default Map<String, String> getVirtualParamMap(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return params;
    }

    /**
     * 虚拟商品请求
     * @return
     */
    default HttpRequestBase getOrderStatusPushHttp(final HttpMessageDO db, final HttpRequestMessageDto msg, AppDO app) {
        return null;
    }


}
