package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.BeijingXiandaiConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SupplierRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chenzhenxing
 * @date 2021/12/10 4:19 下午
 */
@Service
public class BeijingXiandaiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(BeijingXiandaiStrategy.class);

    @Autowired
    private BeijingXiandaiConfig beijingXiandaiConfig;
    @Autowired
    private AppDAO appDAO;

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        Map<String, String> paramMap = getVirtualParamMap(request);
        String goodsNum = paramMap.get("params");
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(beijingXiandaiConfig.getGiveCardTag())) {
            HashMap<String,String> newAuthParams = new HashMap();
            //调用开发者发券接口
            newAuthParams.put("user_hid", paramMap.get("uid"));
//            newAuthParams.put("user_hid", "45a45b2167dc4469a3506fdafdaf8489");
            newAuthParams.put("order_num", paramMap.get("orderNum"));
            newAuthParams.put("card_group_id", goodsNum.replace(beijingXiandaiConfig.getGiveCardTag(),""));
            newAuthParams.put("send_time", System.currentTimeMillis() + "");
            AppDO app = appDAO.getAppByCache(Long.valueOf(request.getAppId()));
            newAuthParams.put("appSecret", appDAO.getAppSecret(app));
            //测试环境写死
//            newAuthParams.put("appSecret", "ZcG7fJ3PjsUKAbfjqtTgrSZw35u");
            String sign = SignTool.sign(newAuthParams);
            newAuthParams.put("sign", sign);
            newAuthParams.remove("appSecret");
            LOGGER.info("北现卡券 BeijingXiandaiStrategy-getVirtualRequest,{},newAuthParams:{}", JSONObject.toJSONString(request), newAuthParams);
            HttpPost post = new HttpPost(beijingXiandaiConfig.getGiveCardUrl());
            post.setEntity(new StringEntity(JSON.toJSONString(newAuthParams), ContentType.APPLICATION_JSON));
            return post;
        }
        return null;
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> paramMap = getVirtualParamMap(request);
        String goodsNum = paramMap.get("params");
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(beijingXiandaiConfig.getGiveCardTag())) {
            LOGGER.info("北现卡券 BeijingXiandaiStrategy-getVirtualResponse,request:{},body:{}", JSONObject.toJSONString(request), body);
            //
            JSONObject response = JSON.parseObject(body);
            JSONObject json = new JSONObject();
            if ("ok".equals(response.getString("status"))) {
                json.put("status", "success");
                json.put(BeijingXiandaiConfig.CARD_ID, response.getString("CardId"));
                json.put(BeijingXiandaiConfig.CARD_NO, response.getString("cardNo"));
                json.put(BeijingXiandaiConfig.EXPIRE_TIME, response.getString("endTime"));
//                json.put(BeijingXiandaiConfig.CARD_NO, "asdasdas");
//                json.put(BeijingXiandaiConfig.EXPIRE_TIME, System.currentTimeMillis());
            } else {
                json.put("status", "fail");
                json.put("errorMessage", response.getString("errorMesssage"));
            }
            return json.toJSONString();
        }
        return body;
    }
}
