package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.CgwsConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author chenzhenxing
 * @date 2021/12/10 4:19 下午
 */
@Service
public class CgwsApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(CgwsApiStrategy.class);

    @Autowired
    private CgwsConfig cgwsConfig;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = dto.getHttpParams().get("orderNum");
        boolean result = StringUtils.isNotBlank(orderNum);
        return result;
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        LOGGER.info("长城证券获取兑换记录同步http包装类 :{}", JSON.toJSONString(msg));
        Map<String, String> json = Maps.newHashMap();
        json.put("orderNum", msg.getHttpParams().get("orderNum"));
        json.put("title",msg.getHttpParams().get("title"));
        json.put("startDay", msg.getHttpParams().get("startDay"));
        json.put("endDay",msg.getHttpParams().get("endDay") );
        json.put("uid", msg.getHttpParams().get("uid"));
        json.put("recordId", msg.getHttpParams().get("recordId"));
        json.put("recordDetailUrl", msg.getHttpParams().get("recordDetailUrl"));
        json.put("orderType",msg.getHttpParams().get("orderType"));
        json.put("itemType",msg.getHttpParams().get("itemType"));
        json.put("cardNum",msg.getHttpParams().get("cardNum"));
        json.put("cardPwd",msg.getHttpParams().get("cardPwd"));
        json.put("credits", msg.getHttpParams().get("credits"));
        json.put("logoUrl", msg.getHttpParams().get("logoUrl"));
        json.put("timestamp", msg.getHttpParams().get("timestamp"));
        json.put("appKey", msg.getHttpParams().get("appKey"));
        json.put("appSecret",msg.getHttpParams().get("appSecret"));
        String sign = SignTool.sign(json);
        json.put("sign", sign);
        json.remove("appSecret");
        String url = AssembleTool.assembleUrl(cgwsConfig.getUrl(),json);
        HttpGet httpGet = new HttpGet(url);
        LOGGER.info("长城证券兑换记录同步url:{}",url);
        return httpGet;
    }


    @Override
    public String getCrecordResponse(String body) {
        LOGGER.info("长城证券定制同步兑换记录响应, resp={}",body);
        return getResponseNotify(null, body);
    }

    @Override
    public String getResponseNotify(NotifyQueueDO notifyQueue, String body) {
        return body;
    }

}
