package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.ginoble.GinobleCreditsResp;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.ginoble.GinobleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 基诺浦-接口定制
 *
 * @author fja
 * @see <a href="https://open.maiscrm.com/docs/openapi/businessAPI.html">...</a>
 */
@Service
public class GinobleApiStrategy implements ApiStrategy {
    @Resource
    private GinobleTool ginobleTool;



    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private final RequestConfig config;

    private static final int FIVE_SECONDS = 5 * 1000;

    private static final int TEN_SECONDS = 5 * 1000;

    {
        //http请求超时配置
        config = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }


    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        Long consumerId = message.getSubCreditsMsg().getConsumerId();


        //请求链接 & 解析
        String url = ginobleTool.getHostName(message.getHttpUrl());
        Map<String, String> originData = AssembleTool.getUrlParams(ginobleTool.getParamUrl(message.getHttpUrl()));
        log.info("[基诺浦]减积分 cid = {} originData = {}", consumerId, JSON.toJSONString(originData));


        HttpPost httpPost = new HttpPost(url);

        Map<String, Object> subCreditsParams = ginobleTool.buildSubCreditsParams(originData);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(subCreditsParams), ContentType.APPLICATION_JSON));
        httpPost.setConfig(config);
        ginobleTool.addHeaders(httpPost);

        log.info("[基诺浦]减积分 cid = {} 请求参数 = {}", consumerId, JSON.toJSONString(subCreditsParams));

        message.setHttpUrl(url);

        return httpPost;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        log.info("[基诺浦] 加、减积分 响应 = {}", body);


        GinobleCreditsResp creditsResp = JSON.parseObject(body, GinobleCreditsResp.class);

        JSONObject result = new JSONObject();
        if(Objects.nonNull(creditsResp.getCode())) {
            result.put("status", "fail");
            result.put("errorMessage", creditsResp.getMessage());
            return result.toJSONString();
        }

        String uid = authParams.get("uid");
        GinobleCreditsResp.CreditsData respItem = creditsResp.getSucceedItems().stream().filter(item -> uid.equals(item.getId())).findAny().orElse(null);



        //成功列表中有，积分操作成功
        if (Objects.nonNull(respItem)) {
            result.put("status", "ok");
            result.put("credits", respItem.getMemberBalance());
            //开发者不返回bizId，随机生成
            result.put("bizId", System.currentTimeMillis() + RandomStringUtils.randomNumeric(6));
        } else {
            result.put("status", "fail");
            result.put("errorMessage", creditsResp.getMessage());
        }

        return result.toJSONString();
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        String consumerId = message.getConsumerId();

        String url = ginobleTool.getHostName(message.getHttpUrl());
        Map<String, String> originData = AssembleTool.getUrlParams(ginobleTool.getParamUrl(message.getHttpUrl()));
        log.info("[基诺浦] 加积分 cid = {} originData = {}", consumerId, JSON.toJSONString(originData));

        HttpPost httpPost = new HttpPost(url);

        Map<String, Object> addCreditsParams = ginobleTool.buildAddCreditsParams(originData);
        log.info("[基诺浦] 加积分 请求参数 = {}", JSON.toJSONString(addCreditsParams));


        httpPost.setEntity(new StringEntity(JSON.toJSONString(addCreditsParams), ContentType.APPLICATION_JSON));
        httpPost.setConfig(config);
        ginobleTool.addHeaders(httpPost);


        return httpPost;
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {

        String url = ginobleTool.getHostName(request.getHttpUrl());
        Map<String, String> originData = AssembleTool.getUrlParams(ginobleTool.getParamUrl(request.getHttpUrl()));
        log.info("[基诺浦] 虚拟商品兑换 originData = {}", JSON.toJSONString(originData));


        String merchantCode = Optional.ofNullable(originData.get("params")).orElse("");
        if (!merchantCode.startsWith(GinobleTool.MERCHANT_CODE_PREFIX)) {
            throw new IllegalStateException(String.format("[基诺浦] 虚拟商品商家编码异常，originData = %s", JSON.toJSONString(originData)));
        }

        HttpPost httpPost = new HttpPost(url);

        Map<String, Object> virtualAddCreditsParams = ginobleTool.buildVirtualAddCreditsParams(originData);
        log.info("[基诺浦] 虚拟商品加积分 请求参数 = {}", JSON.toJSONString(virtualAddCreditsParams));

        httpPost.setEntity(new StringEntity(JSON.toJSONString(virtualAddCreditsParams), ContentType.APPLICATION_JSON));
        httpPost.setConfig(config);
        ginobleTool.addHeaders(httpPost);


        //url解析的数据塞回去，解析响应需要用到
        request.setAuthParams(originData);

        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        log.info("[基诺浦] 虚拟商品加积分 响应 = {}", body);

        GinobleCreditsResp creditsResp = JSON.parseObject(body, GinobleCreditsResp.class);

        JSONObject result = new JSONObject();
        if(Objects.nonNull(creditsResp.getCode())) {
            result.put("status", "fail");
            result.put("errorMessage", creditsResp.getMessage());
            return result.toJSONString();
        }


        String uid = request.getAuthParams().get("uid");
        GinobleCreditsResp.CreditsData respItem = creditsResp.getSucceedItems().stream().filter(item -> uid.equals(item.getId())).findAny().orElse(null);


        //成功列表中有，积分操作成功
        if (Objects.nonNull(respItem)) {
            result.put("status", "ok");
            result.put("credits", respItem.getMemberBalance());
            //开发者不返回bizId，随机生成
            result.put("bizId", System.currentTimeMillis() + RandomStringUtils.randomNumeric(6));
        } else {
            result.put("status", "fail");
            result.put("errorMessage", creditsResp.getMessage());
        }

        return result.toJSONString();
    }
}
