package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import cn.com.duiba.consumer.center.api.dto.ConsumerExtraDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerExtraService;
import cn.com.duiba.credits.sdk.AddCreditsParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.ZhijiAddCreditsDataReq;
import cn.com.duiba.domain.ZhijiAddCreditsReqBody;
import cn.com.duiba.domain.ZhijiAddCreditsReqData;
import cn.com.duiba.domain.ZhijiAddCreditsReqPointList;
import cn.com.duiba.domain.ZhijiAddCreditsRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerOrderSimpleService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/9/3 下午3:31
 */
@Service
public class ZhiJiApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZhiJiApiStrategy.class);

    private final RequestConfig requestConfig;
    private static final int FIVE_SECONDS = 5*1000;
    private static final int TEN_SECONDS = 10*1000;

    private static final String ROLLBACK =  "rollback-";
    @Autowired
    private ZhiJiConfig zhiJiConfig;
    @Autowired
    private ZhiJiParamTool zhiJiParamTool;

    @Autowired
    private RemoteConsumerExtraService remoteConsumerExtraService;

    @Autowired
    private RemoteConsumerOrderSimpleService remoteConsumerOrderSimpleService;

    {
        //http请求超时配置
        requestConfig = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try{
            HttpPost httpPost = new HttpPost(zhiJiConfig.getDomainName() + zhiJiConfig.getAddCreditsUrl());
            AddCreditsParams addCreditsParams = message.getAddCreditsParams();
            ZhijiAddCreditsReqPointList pointList = new ZhijiAddCreditsReqPointList();
            pointList.setAccrualPoints(addCreditsParams.getCredits().intValue());
            ZhijiAddCreditsDataReq dataReq = new ZhijiAddCreditsDataReq();
            dataReq.setPointList(pointList);
            ZhijiAddCreditsReqData reqData = new ZhijiAddCreditsReqData();
            reqData.setListOfIMAccruePointsInput(dataReq);
            ZhijiAddCreditsReqBody body = new ZhijiAddCreditsReqBody();
            ConsumerExtraDto result = remoteConsumerExtraService.findByConsumerId(Long.valueOf(message.getConsumerId())).getResult();
            if(Objects.isNull(result) || StringUtils.isBlank(result.getJson())){
                LOGGER.info("【智几汽车】获取用户扩展字段 出错");
                throw new BizException("获取用户扩展字段 出错");
            }
            body.setSuperId(JSON.parseObject(result.getJson()).getString("sid"));
            body.setData(reqData);
            // 售后时有子订单号传子订单号，没有子订单号传主订单号
            String orderNum = addCreditsParams.getOrderNum();
            if (Objects.equals(addCreditsParams.getType(), "postsale")) {
                orderNum = StringUtils.isBlank(addCreditsParams.getSubOrderNum()) ? addCreditsParams.getOrderNum() : addCreditsParams.getSubOrderNum();
            }
            body.setTraceId(orderNum);
            body.setTransactionNumber(orderNum);
            String transactionType = StringUtils.isBlank(addCreditsParams.getDescription()) ? "兑换商品" : addCreditsParams.getDescription();
            body.setTransactionType(transactionType.length() > 30 ? transactionType.substring(0,30) : transactionType);
            String transfer = message.getAddCreditsParams().getTransfer();

            body.setTransactionTime(transfer);
            ZhijiAddCreditsRequest request = new ZhijiAddCreditsRequest();
            request.setBody(body);
            Map<String, Object> map = BeanUtils.transBeanToMap(request);
            LOGGER.info("【智几汽车】加积分请求，url:{},params:{}",zhiJiConfig.getAddCreditsUrl(),JSON.toJSONString(map));
            httpPost.setEntity(new StringEntity(JSON.toJSONString(request),"UTF-8"));

            // hmac加密
            String signature = zhiJiParamTool.buildHttpHeader(body,zhiJiConfig.getAddCreditsUrl(),httpPost);
            if (signature == null) {
                LOGGER.warn("智己-扣积分参数加密异常，body:{},message:{}", body, JSON.toJSONString(message));
                return null;
            }
            httpPost.setConfig(requestConfig);
            return httpPost;
        }catch (Exception e) {
            LOGGER.warn("【智几汽车】组装加积分接口参数失败",e);
            return null;
        }
    }

    /**
     * 获取兑换结果通知http包装类
     */
    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record){
        try{
            LOGGER.info("智己 getRequestNotify = {}",JSON.toJSONString(record));
            HttpPost httpPost = new HttpPost(zhiJiConfig.getDomainName() + zhiJiConfig.getAddCreditsUrl());
            String duibaOrderNum = record.getDuibaOrderNum();
            OrdersDto ordersDto = remoteConsumerOrderSimpleService.findByOrderNum(duibaOrderNum).getResult();
            ZhijiAddCreditsReqPointList pointList = new ZhijiAddCreditsReqPointList();
            pointList.setAccrualPoints(ordersDto.getCredits().intValue());
            pointList.setPointSubType("Adjust");
            ZhijiAddCreditsDataReq dataReq = new ZhijiAddCreditsDataReq();
            dataReq.setPointList(pointList);
            ZhijiAddCreditsReqData reqData = new ZhijiAddCreditsReqData();
            reqData.setListOfIMAccruePointsInput(dataReq);

            ZhijiAddCreditsReqBody body = new ZhijiAddCreditsReqBody();
            ConsumerExtraDto result = remoteConsumerExtraService.findByConsumerId(record.getConsumerId()).getResult();
            if(Objects.isNull(result) || StringUtils.isBlank(result.getJson())){
                throw new BizException("通知回滚 获取用户扩展字段 出错");
            }
            body.setSuperId(JSON.parseObject(result.getJson()).getString("sid"));
            body.setData(reqData);
            body.setTraceId(ROLLBACK+duibaOrderNum);
            body.setTransactionNumber(ROLLBACK +duibaOrderNum);
            String transactionType = ordersDto.getBrief() + "取消返还";
            body.setTransactionType(transactionType.length() > 30 ? transactionType.substring(0, 28) : transactionType);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            body.setTransactionTime(simpleDateFormat.format(new Date()));
            ZhijiAddCreditsRequest request = new ZhijiAddCreditsRequest();
            request.setBody(body);
            Map<String, Object> map = BeanUtils.transBeanToMap(request);
            LOGGER.info("【智几汽车】通知回滚 加积分请求，url:{},params:{}",zhiJiConfig.getAddCreditsUrl(),JSON.toJSONString(map));

            httpPost.setEntity(new StringEntity(JSON.toJSONString(request),"UTF-8"));

            // hmac加密
            String signature = zhiJiParamTool.buildHttpHeader(body,zhiJiConfig.getAddCreditsUrl(),httpPost);
            if (signature == null) {
                LOGGER.warn("智己-通知回滚参数加密异常，body:{},message:{}", body, JSON.toJSONString(record));
                return null;
            }
            httpPost.setConfig(requestConfig);
            return httpPost;
        }catch (Exception e) {
            LOGGER.warn("【智几汽车】通知回滚 组装加积分接口参数失败",e);
            return null;
        }
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            //请求链接
            HttpPost httpPost = new HttpPost(zhiJiConfig.getDomainName() + zhiJiConfig.getSubCreditsUrl());
            Map<String, String> originData = AssembleTool.getUrlParams(getParamUrl(message.getHttpUrl()));
            LOGGER.info("智己-扣积分参数，params：{}", JSON.toJSONString(originData));
            Map<String, Object> requestParams = Maps.newHashMap();
            // 从url中取，是兑吧官方扣积分文档中的参数，会放在url
            String transactionType = StringUtils.isBlank(originData.get("description")) ? "兑换商品" : originData.get("description");
            requestParams.put("TransactionType", transactionType.length() > 30 ? transactionType.substring(0,30) : transactionType);
            requestParams.put("RedeemNumber", originData.get("orderNum"));
            requestParams.put("TraceId", originData.get("orderNum") + zhiJiParamTool.generateRandom());
            // 定制参数
            Map<String, String> customParams = message.getSubCreditsMsg().getParams();
            requestParams.put("superId", customParams.get("superId"));
            requestParams.put("RedeemTime", customParams.get("TransactionTime"));
            // 固定参数
            requestParams.put("SourceCode", "DUIBA");
            // data格式
            Map<String, Object> data = new HashMap<>(1);
            Map<String, Object> lostOfPointList = new HashMap<>(1);
            Map<String, String> pointList = new HashMap<>(2);
            pointList.put("Type", "Point");
            pointList.put("RedeemPoints", originData.get("credits"));
            lostOfPointList.put("PointList", pointList);
            data.put("ListOfPointList", lostOfPointList);
            requestParams.put("Data", data);
            // 请求参数先放入body中，加密，放入header
            Map<String, Object> body = new HashMap<>(1);
            body.put("body", requestParams);
            LOGGER.info("智己-扣积分参数，url：{}，body：{}，message：{}", zhiJiConfig.getSubCreditsUrl(), body, JSON.toJSONString(message));
            httpPost.setEntity(new StringEntity(JSON.toJSONString(body),"UTF-8"));
            // hmac加密
            String signature = zhiJiParamTool.buildHttpHeader(body,zhiJiConfig.getSubCreditsUrl(),httpPost);
            if (signature == null) {
                LOGGER.warn("智己-扣积分参数加密异常，body:{},message:{}", body, JSON.toJSONString(message));
                return null;
            }
            httpPost.setConfig(requestConfig);
            return httpPost;
        } catch (Exception e) {
            LOGGER.warn("智己-扣积分参数加密异常，message:{}", JSON.toJSONString(message), e);
            return null;
        }
    }

    /**
     * 智己积分返回参数解析
     * @param body
     * @param addCredits
     * @param authParams
     * @return
     */
    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        LOGGER.info("智己-积分返回参数，params：{}", body);
        JSONObject response = JSON.parseObject(body);
        JSONObject result = new JSONObject();
        result.put("bizId", response.get("TxnId"));
        if (Objects.equals("0", response.get("ErrorCode"))) {
            result.put("status","ok");
        } else {
            result.put("status", "fail");
        }
        result.put("errorMessage", response.get("ErrorMessage"));
        return result.toJSONString();
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf('?') + 1);
    }



    public static void main(String[] args) {
//        ZhijiAddCreditsRequest zhijiAddCreditsRequest = JSON.parseObject("{\"body\":{\"data\":{\"listOfIMAccruePointsInput\":{\"pointList\":{\"accrualPoints\":25,\"pointSubType\":\"Adjust\",\"pointType\":\"Point\"}}},\"sourceCode\":\"DUIBA\",\"superId\":\"1000000001788051\",\"traceId\":\"179463326234202C0025\",\"transactionNumber\":\"179463326234202C0025\",\"transactionTime\":\"\"}}", ZhijiAddCreditsRequest.class);
//        Map<String, Object> map = BeanUtils.transBeanToMap(zhijiAddCreditsRequest);
//        JSONObject jsonObject = new JSONObject();
//        System.out.println(JsonTool.objectToJson(map));
//        System.out.println(JSON.toJSONString(map));
//
//        String s = "{\"newUser\":0,\"sid\":\"111\"}";
//
//        System.out.println(JSON.parseObject(s).getString("sid"));

        Date now = new Date();

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        System.out.printf(simpleDateFormat.format(now));
    }

    @Override
    public Boolean appIdCheck(Long appId){
        return zhiJiConfig.getAppIds().contains(appId);
    }
}
