package cn.com.duiba.biz.credits.strategy.Impl.kouweiwang;

import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.api.enums.HttpRequestResultType;
import cn.com.duiba.api.enums.subcredits.SubCreditsType;
import cn.com.duiba.biz.Exception.KwwException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.kouweiwang.KwwConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.service.KwwOrderSyncService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.kouweiwang.KwwOrderStatusEnum;
import cn.com.duiba.thirdparty.dto.kouweiwang.KwwRespBodyDto;
import cn.com.duiba.thirdparty.dto.kouweiwang.KwwRespDataDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.kouweiwang.KwwTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 口味王接口订制
 *
 * @author fja
 */
@Service
public class KwwApiStrategy implements ApiStrategy {

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Resource
    private KwwTool kwwTool;

    @Resource
    private KwwConfig kwwConfig;

    @Resource
    private KwwOrderSyncService kwwOrderSyncService;

    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    private static final int THREE_SECONDS = 5 * 1000;


    private final RequestConfig config;
    {
        //http请求超时配置
        config = RequestConfig.custom().setConnectTimeout(THREE_SECONDS).setSocketTimeout(THREE_SECONDS).setConnectionRequestTimeout(500).build();
    }

    /**
     * 目前扣积分只有 积分商城普兑（卡券）
     *
     * @return http对象
     */
    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message) {
        //请求链接 & 解析
        String url = kwwTool.getHostName(message.getHttpUrl());
        String consumerId = message.getConsumerId();

        Map<String, Object> params = Maps.newHashMap();
        try {
            params.put("userId", message.getAuthParams().get("uid"));
            params.put("amount", message.getAuthParams().get("credits"));
            params.put("actionDesc", message.getAuthParams().get("description"));
            params.put("busNo", message.getAuthParams().get("orderNum"));
            params.put("type", "activity");
            //加密
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(params));
            log.info("kww减积分 cid = {} 参数-未加密 = {} 加密 = {}", consumerId, JSON.toJSONString(params), cipherText);

            HttpPost httpPost = new HttpPost(url);
            // 构建请求头
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);
            return httpPost;
        } catch (Exception e) {
            log.warn(String.format("kww cid=【%s】 生成扣积分请求失败，originData = 【%s】", consumerId, JSON.toJSONString(params)), e);
            throw new IllegalStateException(e);
        }
    }

    /**
     * 目前扣积分只有 积分商城普兑（卡券）
     *
     * @return http对象
     */
    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        //请求链接 & 解析
        String url = kwwTool.getHostName(message.getHttpUrl());
        Map<String, String> originData = AssembleTool.getUrlParams(kwwTool.getParamUrl(message.getHttpUrl()));

        //如果是普兑
        Pair<String, Boolean> pair = syncOrder(message);
        String bizId = pair.getLeft();
        if(!pair.getRight()){
            return null;
        }

        //拼接请求参数
        Map<String, Object> params = buildSubCreditsParams(originData, message);

        try {
            //加密
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(params));
            log.info("kww减积分 orderId = {} 参数-未加密 = {} 加密 = {}", message.getSubCreditsMsg().getRelationId(), JSON.toJSONString(params), cipherText);

            HttpPost httpPost = new HttpPost(url);
            // 构建请求头
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);

            message.setHttpUrl(url);
            message.getSubCreditsMsg().setAuthParams(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));
            log.info("kww减积分 orderId={}, bizId={}", message.getSubCreditsMsg().getRelationId(), bizId);

            return httpPost;
        } catch (Exception e) {
            log.warn(String.format("kww orderId=【%s】生成扣积分请求失败，originData = 【%s】", message.getSubCreditsMsg().getRelationId(), JSON.toJSONString(originData)), e);
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    private Pair<String,Boolean> syncOrder(SubCreditsMsgWrapper message) {
        String bizId = null;
        //普兑且是优惠券,同步订单信息
        if(message.getSubCreditsMsg() != null && message.getSubCreditsMsg().getRelationType() != null && Objects.equals(SubCreditsType.MALL.getMsg(), message.getSubCreditsMsg().getRelationType().getMsg()) && Objects.equals(OrdersDto.type_coupon, message.getSubCreditsMsg().getCreditConsumeParams().getType())){
            if(MapUtils.isNotEmpty(message.getSubCreditsMsg().getParams()) && StringUtils.isNotBlank(message.getSubCreditsMsg().getParams().get("syncOrder"))){
                String syncOrder = message.getSubCreditsMsg().getParams().get("syncOrder");
                try{
                    KwwRespBodyDto kwwRespBodyDto = kwwOrderSyncService.sendOrderInfo2Developer(message.getSubCreditsMsg().getAppId(), syncOrder);
                    if (KwwRespBodyDto.SUCCESS.equals(kwwRespBodyDto.getResult()) && kwwRespBodyDto.getEntity() != null){
                        bizId = kwwRespBodyDto.getEntity().getOrderNo();
                        return Pair.of(bizId, true);
                    }else{
                        log.warn("kww同步失败：order:{}", message.getSubCreditsMsg().getRelationId());
                        finallyBlock(message, kwwRespBodyDto.getMessage());
                        return Pair.of(null, false);
                    }
                }catch (Exception e){
                    log.warn("kww同步订单出错 orderId={}, syncOrder={}", message.getSubCreditsMsg().getRelationId(), syncOrder, e);
                    throw new KwwException("kww同步订单出错");
                }
            }else{
                log.warn("kww同步订单出错 orderId={}", message.getSubCreditsMsg().getRelationId());
                throw new KwwException("kww未传商品信息");
            }
        }
        return Pair.of(null, true);
    }

    private void finallyBlock(SubCreditsMsgWrapper req, String callbackBody) {
        String body = null;
        try {
            SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
            resp.setResultType(HttpRequestResultType.COMPLETED);
            resp.setCode(SubCreditsResultMsgDto.CODE_PARSE_JSON_FAIL);
            resp.setErrorMessage(callbackBody);
            resp.setResponse(callbackBody);

            resp.setRelationId(req.getSubCreditsMsg().getRelationId());
            resp.setRelationType(req.getSubCreditsMsg().getRelationType());
            resp.setParams(req.getSubCreditsMsg().getParams());
            resp.setAppId(req.getSubCreditsMsg().getAppId());
            resp.setConsumerId(req.getSubCreditsMsg().getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            // 扣积分回调
            body = JsonTool.objectToJson(resp);
            rocketMQMsgProducer.sendMsg(req.getSubCreditsMsg().getCallbackTopic(), req.getSubCreditsMsg().getCallbackTag(), req.getSubCreditsMsg().getCallbackTag(), body, false, null);
        } catch (Exception e) {
            log.warn("credits callback: bizId:" + req.getSubCreditsMsg().getRelationId() + " bizType:" + req.getSubCreditsMsg().getRelationType(), e);
        } finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [bizId " + req.getSubCreditsMsg().getRelationId() + "] [type " + req.getSubCreditsMsg().getRelationType() + "] [body " + callbackBody + "]");
        }
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        JSONObject result = new JSONObject();

        //解密
        KwwRespBodyDto kwwCreditsRespBody;
        try {
            if (kwwTool.isJsonString(body)) {
                throw new IllegalArgumentException(body);
            }

            String plainText = kwwTool.aesDecrypt(body);
            log.info("[kww]积分接口响应 orderNum = {} 密文 ={} 解密后= {}", authParams.get("busNo"), body, plainText);
            kwwCreditsRespBody = JSON.parseObject(plainText, KwwRespBodyDto.class);
            if (!KwwRespBodyDto.SUCCESS.equals(kwwCreditsRespBody.getResult())) {
                log.warn("kww扣积分失败：order:{}", authParams.get("busNo"));
            }
        } catch (Exception e) {
            log.warn(String.format("kww解析积分响应 orderNum = %s body = %s 解密异常 authParams = %s", authParams.get("busNo"), body, JSON.toJSONString(authParams)), e);
            throw new IllegalStateException(e);
        }


        if (KwwRespBodyDto.SUCCESS.equals(kwwCreditsRespBody.getResult())) {
            result.put("status", "ok");
            KwwRespDataDto respData = kwwCreditsRespBody.getEntity();
            if (Objects.nonNull(respData) && Objects.nonNull(respData.getAmount())) {
                //返回用户最新积分
                result.put("credits", respData.getAmount());
                // 开发者不返回订单号，自定义
                String bizId = respData.getOrderNo();
                if(StringUtils.isNotBlank(bizId)){
                    result.put("bizId", bizId);
                }else{
                    result.put("bizId", "g" + System.currentTimeMillis() + RandomStringUtils.randomNumeric(6));
                }
            } else {
                log.warn(String.format("kww 解析积分响应 authParams = 【%s】 无积分返回 respData = 【%s】", JSON.toJSONString(authParams), JSON.toJSONString(respData)));
            }
        } else {
            result.put("status", "fail");
            result.put("errorMessage", kwwCreditsRespBody.getMessage());
            if(kwwCreditsRespBody.getEntity() != null && StringUtils.isNotBlank(kwwCreditsRespBody.getEntity().getResCode())){
                result.put("errorMessage", kwwCreditsRespBody.getEntity().getResCode() + "_" + kwwCreditsRespBody.getMessage());
            }
        }

        return result.toJSONString();
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        //请求链接 & 解析
        String url = kwwTool.getHostName(message.getHttpUrl());
        Map<String, String> originData = AssembleTool.getUrlParams(kwwTool.getParamUrl(message.getHttpUrl()));


        String consumerId = message.getConsumerId();
        log.info("[kww]加积分 cid = {} originData = {}", consumerId, JSON.toJSONString(originData));

        //拼接请求参数
        boolean isProjectx = "projectX".equals(message.getRelationType());
        Map<String, Object> params = buildAddCreditsParams(originData, isProjectx);

        try {
            //加密
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(params));
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);


            message.setHttpUrl(url);
            message.setAuthParams(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));

            return httpPost;
        } catch (Exception e) {
            log.warn(String.format("kww加积分 cid = 【%s】 生成加积分请求失败，originData = 【%s】", consumerId, JSON.toJSONString(originData)), e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        //口味王虚拟商品兑换走加积分
        //请求链接 & 解析
        String url = kwwTool.getHostName(request.getHttpUrl());
        Map<String, String> originData = AssembleTool.getUrlParams(kwwTool.getParamUrl(request.getHttpUrl()));
        log.info("[kww]虚拟商品兑换originData = {}", JSON.toJSONString(originData));

        String merchantCode = Optional.ofNullable(originData.get("params")).orElse("");
        if (!merchantCode.startsWith("JF")) {
            throw new IllegalStateException(String.format("kww虚拟商品商家编码异常，originData = %s", JSON.toJSONString(originData)));
        }


        Map<String, Object> params = buildVirtualExchangeParams(originData, merchantCode);

        try {
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(params));
            log.info("[kww]虚拟商品兑换 orderId = {} 参数-未加密 = {} 加密 = {}", request.getOrderId(), JSON.toJSONString(params), cipherText);


            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);


            request.setHttpUrl(url);
            request.setAuthParams(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));
            return httpPost;
        } catch (Exception e) {
            log.warn(String.format("kww虚拟商品兑换 orderId = 【%s】 生成虚拟商品兑换请求失败，originData = 【%s】", request.getOrderId(), JSON.toJSONString(originData)), e);
            throw new IllegalStateException(e);
        }
    }


    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        JSONObject result = new JSONObject();

        //解密
        KwwRespBodyDto kwwCreditsRespBody;
        try {
            if (kwwTool.isJsonString(body)) {
                throw new IllegalStateException(body);
            }

            String plainText = kwwTool.aesDecrypt(body);
            log.info("[kww]虚拟商品兑换接口响应 orderId = {}, 响应 = {}", request.getOrderId(), plainText);

            kwwCreditsRespBody = JSON.parseObject(plainText, KwwRespBodyDto.class);
        } catch (Exception e) {
            log.warn(String.format("kww解析虚拟商品响应 解密异常 authParams = %s  body = %s", JSON.toJSONString(request.getAuthParams()), body), e);
            throw new IllegalStateException(e);
        }


        if (KwwRespBodyDto.SUCCESS.equals(kwwCreditsRespBody.getResult())) {
            result.put("status", "success");
            if (Objects.nonNull(request.getSupplierOrderId())) {
                //kww没有返回，随机生成一个放到主订单里，没啥影响
                result.put("supplierBizId", System.currentTimeMillis() + RandomStringUtils.randomNumeric(6));
            }

            KwwRespDataDto respData = kwwCreditsRespBody.getEntity();
            if (Objects.nonNull(respData) && Objects.nonNull(respData.getAmount())) {
                //返回用户最新积分
                result.put("credits", respData.getAmount());
            }
        } else {
            result.put("status", "fail");
            result.put("errorMessage", kwwCreditsRespBody.getMessage());
        }


        return result.toJSONString();
    }

    /**
     * 通知接口不调用，全部走监听接口，原因（因为通知针对整个平台（积分商城，积分商城活动，星速台活动），但程序中的通知只针对普兑且非0积分，可禁掉通知功能(skip.nofity.appIdSet)，定制监听针对全平台，避免积分商城非0积分订单调多次通知）
     * @param notifyUrl
     * @param record
     * @return
     */
    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        HttpPost httpPost = new HttpPost(notifyUrl);
        String partnerUserId = record.getPartnerUserId();

        try {
            Map<String, String> params = buildNotifyParams(record);
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(params));
            log.info("[kww]通知 参数未加密 = {} 加密 = {}", JSON.toJSONString(params), cipherText);

            //生成HttpPost
            httpPost.setHeader("appId", kwwConfig.getKwwAppId());
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);


            return httpPost;
        } catch (Exception e) {
            log.warn(String.format("kww通知 uid =【%s】 生成notify请求失败，NotifyQueueDO = 【%s】", partnerUserId, JSON.toJSONString(record)), e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getResponseNotify(NotifyQueueDO notifyQueue, String body) {
        //解密
        KwwRespBodyDto kwwNotifyResp;
        try {
            if (kwwTool.isJsonString(body)) {
                throw new IllegalArgumentException(body);
            }

            String result = kwwTool.aesDecrypt(body);
            kwwNotifyResp = JSON.parseObject(result, KwwRespBodyDto.class);
            log.info("kww兑换结果通知order:{}, 结果:{}", notifyQueue.getDuibaOrderNum(), JSON.toJSONString(kwwNotifyResp));
            //如果口味王有返回值，就表示此次通知成功
            if (kwwNotifyResp != null) {
                if (!KwwRespBodyDto.SUCCESS.equals(kwwNotifyResp.getResult())) {
                    log.warn("kww兑换结果通知失败：order:{}", notifyQueue.getDuibaOrderNum());
                }
                return "ok";
            }else{
                return body;
            }
        } catch (Exception e) {
            log.warn(String.format("kww订单 = %s 兑换结果通知 发送异常", notifyQueue.getDuibaOrderNum()), e);
            throw new IllegalStateException("kww兑换结果通知出错");
        }
    }

    /**
     * 生成口味王的扣积分请求参数
     *
     * @param originData 数据
     * @return 扣积分请求参数
     */
    private Map<String, Object> buildSubCreditsParams(Map<String, String> originData, SubCreditsMsgWrapper message) {
        Map<String, Object> params = Maps.newHashMap();

        params.put("userId", originData.get("uid"));
        params.put("amount", Integer.parseInt(originData.get("credits")));
        params.put("actionDesc", originData.get("description"));
        params.put("busNo", originData.get("orderNum"));
        params.put("type", "activity");
        if(message.getSubCreditsMsg() != null && message.getSubCreditsMsg().getRelationType() != null && Objects.equals(SubCreditsType.MALL.getMsg(), message.getSubCreditsMsg().getRelationType().getMsg())){
            params.put("type", "order");
        }

        return params;
    }


    /**
     * 生成口味王的加积分请求参数
     *
     * @param originData 数据
     * @return 加积分请求参数
     */
    private Map<String, Object> buildAddCreditsParams(Map<String, String> originData, boolean isProjectx) {
        Map<String, Object> params = Maps.newHashMap();


        params.put("userId", originData.get("uid"));
        params.put("amount", Integer.parseInt(originData.get("credits")));
        params.put("busNo", originData.get("orderNum"));

        //固定传task
        params.put("type", "task");

        //星速台的加积分描述 已 @ 分割description@subType
        if (isProjectx) {
            String desc = originData.get("description");
            List<String> splitToList = Splitter.on("@").omitEmptyStrings().splitToList(desc);

            if(splitToList.size() > 1){
                params.put("actionDesc", splitToList.get(0));
                params.put("subType", splitToList.get(1));
            }else{
                params.put("actionDesc", desc);
            }
        } else {
            params.put("actionDesc", originData.get("description"));
        }

        return params;
    }


    /**
     * 生成口味王的虚拟商品兑换请求参数
     *
     * @param originData   数据
     * @param merchantCode 商家变吗
     * @return 虚拟商品兑换请求参数
     */
    private Map<String, Object> buildVirtualExchangeParams(Map<String, String> originData, String merchantCode) {
        Map<String, Object> params = Maps.newHashMap();


        params.put("userId", originData.get("uid"));
        String amountStr = merchantCode.replace("JF", "");
        params.put("amount", Integer.parseInt(amountStr));
        params.put("busNo", originData.get("orderNum"));
        //固定传recharge
        params.put("type", "recharge");
        params.put("actionDesc", originData.get("description"));


        return params;
    }

    /**
     * 生成通知businessObject对象
     *
     * @param record 通知DO
     * @return bizObject对象
     */
    private Map<String, String> buildNotifyParams(NotifyQueueDO record) {
        Map<String, String> bizParams = Maps.newHashMap();

        bizParams.put("userId", record.getPartnerUserId());
        KwwOrderStatusEnum kwwOrderStatusEnum = isExchangeSuccess(record);
        bizParams.put("status", kwwOrderStatusEnum.getCode());
        bizParams.put("orderNo", record.getDuibaOrderNum());
        bizParams.put("msg", kwwOrderStatusEnum.getDesc());

        return bizParams;
    }


    /**
     * 订单是否成功
     *
     * @param record 记录
     * @return 00: 兑换失败 10: 兑换成功
     */
    private KwwOrderStatusEnum isExchangeSuccess(NotifyQueueDO record) {
        return BooleanUtils.isTrue(record.getResult()) ? KwwOrderStatusEnum.SUCCESS : KwwOrderStatusEnum.FAIL;
    }
}
