package cn.com.duiba.biz.phonebill.supplier;

import cn.com.duiba.domain.MessageUniqueCheckDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.ParserUtil;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XiangShangPhoneBillSupplier {

    private static Logger log = LoggerFactory.getLogger(XiangShangPhoneBillSupplier.class);
    private static final int MAX_TIMEOUT = 5000;

    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;


    /**
     * 提交到HTTP请求池
     *
     * @param message
     * @param callbackTopic
     * @param msgTag
     * @param msgKey
     */
    public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {

        if (!messageService.messageUniqueCheck(message.getSupplierOrderId(), MessageUniqueCheckDO.TYPE_PHONEBILL)) {
            return;
        }


        String bodyContent = message.getParams().get("entity");

        log.info("向上话费充值，请求，url={}，body={}", message.getHttpUrl(), bodyContent);
        HttpPost post = AssembleTool.assembleRequest(message.getHttpUrl(), ParserUtil.parseAttr2KVMap(bodyContent));
        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(MAX_TIMEOUT)
                .setConnectTimeout(MAX_TIMEOUT).build();
        post.setConfig(requestConfig);
        HttpRequestLog.logUrl("[action phonebill] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
        httpAsyncClientPool.submitForXiangShang(message.getAppId(), post, new FutureCallback<HttpResponse>() {

            @Override
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    buildSupplierResponse(resp, message);
                    resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_COMPLETED);
                    String body = EntityUtils.toString(response.getEntity());
                    resp.setBody(body);
                } catch (Exception e) {
                    log.error("XiangShangPhoneBillSupplier completed", e);
                } finally {
                    finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            @Override
            public void failed(Exception ex) {
                log.error("XiangShangPhoneBillSupplier failed orderId:" + message.getOrderId(), ex);

                SupplierResponse resp = new SupplierResponse();
                try {
                    buildSupplierResponse(resp, message);
                    resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                } catch (Exception e) {
                    log.error("XiangShangPhoneBillSupplier completed", e);
                } finally {
                    finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            @Override
            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    buildSupplierResponse(resp, message);
                    resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_CANCELLED);
                } catch (Exception e) {
                    log.error("XiangShangPhoneBillSupplier cancelled", e);
                } finally {
                    finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }
        });
    }

    private void buildSupplierResponse(SupplierResponse resp, SupplierRequest message) {
        resp.setUrl(message.getHttpUrl());
        resp.setSupplierName(message.getSupplierName());
        resp.setSupplierOrderId(message.getSupplierOrderId());
        resp.setOrderId(message.getOrderId());
        resp.setAppId(message.getAppId());
        resp.setConsumerId(message.getConsumerId());
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
        try {
            String body = JsonTool.objectToJson(response);
            log.info("向上话费充值，响应，url={} body={} callbackTopic={} msgTag={}", message.getHttpUrl(), body, callbackTopic, msgTag);
            HttpRequestLog.logUrl("[action phonebill] [tag response] [callback " + response.getCallbackType() + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "]");
            rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body, false, null);

        } catch (Exception e) {
            log.error("XiangShangPhoneBillSupplier callback:" + message.getOrderId(), e);
        }
    }

}
