package cn.com.duiba.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author xcw
 * @create 2021/3/16
 * @since 1.0.0
 */
@Configuration
@ConfigurationProperties(prefix = "hnao.xucw")
public class HnConstants implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HnConstants.class);

    private Set<Long> appIds= Sets.newHashSet(82612L);
    private String appKey = "c638fddd08dbd1a5449452e7975737a7";

    private String signKey = "677cA6c998e9DaDGaB12fGh22h06487K";

    private String regionId = "4";

    private String hnaopAddress = "http://119.39.227.91:20110/oppf?";

    private String config = "{\"RED_74742021011801\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“春日大作战”活动中获得的“3元话费券”已发放，即日起3天内请到“湖南联通手机营业厅-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021011801\"},\"RED_74742021031201\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“春日大作战”活动中获得的“3元话费券”已发放，即日起3天内请到“湖南联通手机营业厅-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021031201\"},\"RED_74742021031202\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“春日大作战”活动中获得的“3元话费券”已发放，即日起3天内请到“湖南联通手机营业厅-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021031202\"},\"CBSS_1000000000381853\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“春日大作战”活动中获得的“美团外卖红包5元”已发放，即日起3天内请到“湖南联通手机营业厅-我的-我的礼包-卡券兑换使用，逾期失效https://u.10010.cn/qA4mH\",\"benefitId\":\"1000000000381853\"},\"CBSS_1000000000374425\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“优酷VIP会员-周卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000374425\"},\"RED_74742021032901\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在湖南联通活动中获得的“2元话费券”已发放，即日起3天内请到“中国联通APP-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021032901\"},\"RED_74742021032903\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在湖南联通活动中获得的“5元话费券”已发放，即日起3天内请到“中国联通APP-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021032903\"},\"RED_74742021032905\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在湖南联通活动中获得的“20元话费券”已发放，即日起3天内请到“中国联通APP-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021032905\"},\"RED_74742021032906\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在湖南联通活动中获得的“100元话费券”已发放，即日起3天内请到“中国联通APP-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021032906\"},\"CBSS_1000000000374027\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“月月领，话费礼”活动中获得的“京东E卡10元”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA4mH\",\"benefitId\":\"1000000000374027\"},\"CBSS_1000000000374628\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“月月领，话费礼”活动中获得的“爱奇艺黄金VIP会员-周卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA4mH\",\"benefitId\":\"1000000000374628\"},\"CBSS_1000000000381041\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“月月领，话费礼”活动中获得的“京东读书VIP月卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA4mH\",\"benefitId\":\"1000000000381041\"},\"CBSS_1000000000391004\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“拼多多60元现金红包”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000391004\"},\"CBSS_1000000000374025\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“腾讯视频VIP会员-周卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000374025\"},\"CBSS_1000000000373428\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“芒果TVPC移动影视会员-周卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000373428\"},\"CBSS_1000000000373825\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“爱奇艺黄金VIP会员-月卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000373825\"},\"CBSS_1000000000373427\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“优酷VIP会员-月卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000373427\"},\"CBSS_1000000000373828\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“421湖南联通用户节”活动中获得的“京东E卡100元”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000373828\"},\"CBSS_1000000000390603\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在湖南联通活动中获得的“饿了么红包”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000390603\"},\"RED_74742021042204\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“湖南联通5月话费节”活动中获得的“1元联通话费券”已发放，即日起3天内请到“中国联通APP-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021042204\"},\"RED_74742021032904\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在 “湖南联通六月话费节” 活动中获得的 “10元联通话费券” 已发放，即日起 3 天内请到 “中国联通APP - 我的 - 我的钱包 - 电子券” 兑换使用，逾期失效 https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021032904\"},\"RED_74742021042203\":{\"benefitType\":\"RED_PACKAGE_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在“湖南联通5月话费节”活动中获得的“521元联通话费券”已发放，即日起3天内请到“中国联通APP-我的-我的钱包-电子券”兑换使用，逾期失效https://u.10010.cn/qA9bU\",\"benefitId\":\"74742021042203\"},\"CBSS_1000000000391005\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"湖南联通】尊敬的用户，您在“湖南联通5月话费节”活动中获得的“哔哩哔哩漫画限免卡”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000391005\"},\"CBSS_1000000000390604\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"湖南联通】尊敬的用户，您在“湖南联通5月话费节”活动中获得的“顺丰快运100元寄件礼包”已发放，即日起3天内请到“中国联通APP-我的-我的礼包-卡券”兑换使用，逾期失效https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000390604\"},\"CBSS_1000000000389407\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在湖南联通活动中获得的 “腾讯视频VIP周卡” 已发放，即日起 3 天内请到 “中国联通APP - 我的 - 我的礼包 - 卡券” 兑换使用，逾期失效 https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000389407\"},\"CBSS_1000000000389809\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在 “湖南联通人人拉新” 活动中获得的 “京东E卡10元” 已发放，即日起 3 天内请到 “中国联通APP - 我的 - 我的礼包 - 卡券” 兑换使用，逾期失效 https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000389809\"},\"CBSS_1000000000390805\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在 “湖南联通人人拉新” 活动中获得的 “京东E卡30元” 已发放，即日起 3 天内请到 “中国联通APP - 我的 - 我的礼包 - 卡券” 兑换使用，逾期失效 https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000390805\"},\"CBSS_1000000000393201\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在 “湖南联通人人拉新” 活动中获得的 “京东E卡80元” 已发放，即日起 3 天内请到 “中国联通APP - 我的 - 我的礼包 - 卡券” 兑换使用，逾期失效 https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000393201\"},\"CBSS_1000000000391802\":{\"benefitType\":\"CBSS_BENEFIT_CENTER\",\"smsContent\":\"【湖南联通】尊敬的用户，您在 “湖南联通人人拉新” 活动中获得的 “京东E卡100元” 已发放，即日起 3 天内请到 “中国联通APP - 我的 - 我的礼包 - 卡券” 兑换使用，逾期失效 https://u.10010.cn/qA6y3\",\"benefitId\":\"1000000000391802\"}}";

    private Map<String, Map<String, String>> configMap;

    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            configMap = JSON.parseObject(config, new TypeReference<Map<String, Map<String, String>>>() {
            });
        } catch (Exception e) {
            LOGGER.warn("湖南联通加载虚拟商品异常", e);
        }
    }

    public Map<String, Map<String, String>> getConfigMap() {
        return configMap;
    }

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getSignKey() {
        return signKey;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getHnaopAddress() {
        return hnaopAddress;
    }

    public void setHnaopAddress(String hnaopAddress) {
        this.hnaopAddress = hnaopAddress;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }
}