package cn.com.duiba.config;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * Created by xutao on 2018/12/24.
 */
@Configuration
@ConfigurationProperties(prefix = "mengniu")
public class MengNiuConfig {
    private Set<Long> appIds = Sets.newHashSet(87838L);

    /**
     * 蒙牛提供的appId
     */
    private Long mengniuAppId;
    /**
     * 蒙牛提供的secret
     */
    private String mengniuSecret;
    /**
     * 获取token
     */
    private String accessTokenUrl;
    /**
     * 同步商品
     */
    private String syncGoodsUrl;
    /**
     * 同步库存
     */
    private String syncStockUrl;
    /**
     * 上线时间
     */
    private String onlineDate;

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public Long getMengniuAppId() {
        return mengniuAppId;
    }

    public void setMengniuAppId(Long mengniuAppId) {
        this.mengniuAppId = mengniuAppId;
    }

    public String getMengniuSecret() {
        return mengniuSecret;
    }

    public void setMengniuSecret(String mengniuSecret) {
        this.mengniuSecret = mengniuSecret;
    }

    public String getAccessTokenUrl() {
        return accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getSyncGoodsUrl() {
        return syncGoodsUrl;
    }

    public void setSyncGoodsUrl(String syncGoodsUrl) {
        this.syncGoodsUrl = syncGoodsUrl;
    }

    public String getSyncStockUrl() {
        return syncStockUrl;
    }

    public void setSyncStockUrl(String syncStockUrl) {
        this.syncStockUrl = syncStockUrl;
    }

    public String getOnlineDate() {
        return onlineDate;
    }

    public void setOnlineDate(String onlineDate) {
        this.onlineDate = onlineDate;
    }
}
