package cn.com.duiba.config;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.RuxinApiStrategy;
import cn.com.duiba.tool.ruxin.RuxinHttpApiClientpublicActivityGroup;
import cn.com.duiba.tool.ruxin.RuxinHttpsApiClientpublicActivityGroup;
import com.alibaba.cloudapi.sdk.model.HttpClientBuilderParams;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * 如新定制
 */
@Configuration
@ConfigurationProperties(prefix = "ruxin")
public class RuXinConfig implements InitializingBean {

    @Autowired
    private RuxinApiStrategy ruxinApiStrategy;

    private Set<Long> appIds = Sets.newHashSet(82612L);

    /**
     * 加积分
     */
    private String addCredits = "/api/v1/yundt/trade/promotion/duiba/addIntegral";
    /**
     * 减积分
     */
    private String deductCredits = "/api/v1/yundt/trade/promotion/duiba/deductIntegral";
    /**
     * 兑换结果
     */
    private String exchangeResult = "/api/v1/yundt/trade/promotion/duiba/exchangeResult";
    /**
     * 推送订单
     */
    private String pushOrder = "/api/v1/yundt/trade/promotion/duiba/pushorder";
    /**
     * 阿里云appkey
     */
    private String aliyunAppKey = "204055276";
    /**
     * 阿里云secret
     */
    private String aliyunAppSecret = "bFPpc2bKK5sJR5fLq30RZteJttHRrOhK";

    /**
     * 域名
     */
    private String host="api.cn.nuskin.com";

    /**
     * 请求头参数
     */
    private String requestHeader = "PRE";


    public String getRequestHeader() {
        return requestHeader;
    }

    public void setRequestHeader(String requestHeader) {
        this.requestHeader = requestHeader;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(appIds,ruxinApiStrategy);

    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAliyunAppKey() {
        return aliyunAppKey;
    }

    public void setAliyunAppKey(String aliyunAppKey) {
        this.aliyunAppKey = aliyunAppKey;
    }

    public String getAliyunAppSecret() {
        return aliyunAppSecret;
    }

    public void setAliyunAppSecret(String aliyunAppSecret) {
        this.aliyunAppSecret = aliyunAppSecret;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAddCredits() {
        return addCredits;
    }

    public void setAddCredits(String addCredits) {
        this.addCredits = addCredits;
    }

    public String getDeductCredits() {
        return deductCredits;
    }

    public void setDeductCredits(String deductCredits) {
        this.deductCredits = deductCredits;
    }

    public String getExchangeResult() {
        return exchangeResult;
    }

    public void setExchangeResult(String exchangeResult) {
        this.exchangeResult = exchangeResult;
    }

    public String getPushOrder() {
        return pushOrder;
    }

    public void setPushOrder(String pushOrder) {
        this.pushOrder = pushOrder;
    }
}