package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.BeijingXiandaiStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.*;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description:
 */
@Configuration
@ConfigurationProperties("beijing.xiandai")
public class BeijingXiandaiConfig {

    //========OrdersDto Ext Key========
    /**
     * 发放卡券标识 true false
     */
    public final static String GIVE_CARD_KEY="giveCard";
    /**
     * 商家编码
     */
    public final static String  MERCHANT_CODE="merchantCode";
    /**
     * 过期时间
     */
    public final static String  EXPIRE_TIME="expireTime";
    /**
     * 核销码
     */
    public final static String  CARD_NO="cardNo";
    /**
     * 卡券Id
     */
    public final static String  CARD_ID="cardId";


    @Autowired
    private BeijingXiandaiStrategy beijingXiandaiStrategy;

    private static final Logger logger = LoggerFactory.getLogger(BeijingXiandaiConfig.class);



    private Set<Long> appIds = Sets.newHashSet();

    /**
     * 发券接口
     */
    private String giveCardUrl = "https://pre-api.bhmc.com.cn/v1/app/white/duiba/send_card";

    /**
     * 发放卡券标识
     */
    private String giveCardTag="giveCard";

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
        logger.info("beijing.xiandai.appIds:{}",appIds);
        if (CollectionUtils.isNotEmpty(appIds)){
            ApiStrategyRouter.register(appIds,beijingXiandaiStrategy);
        }
    }

    public String getGiveCardUrl() {
        return giveCardUrl;
    }

    public void setGiveCardUrl(String giveCardUrl) {
        this.giveCardUrl = giveCardUrl;
    }

    public String getGiveCardTag() {
        return giveCardTag;
    }

    public void setGiveCardTag(String giveCardTag) {
        this.giveCardTag = giveCardTag;
    }
}
