package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @Author: lufeng
 * @Description: 广发中心配置信息
 * @Date: Created in 2020/6/18
 */
@Configuration
@ConfigurationProperties(prefix = "cgb.bank")
public class CgbBankConfig {

    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(1L, 75261L);

    /**
     * 调用广发中心地址
     */
    private String httpUrl = "http://218.13.4.194:30041/gateway/API/LifeValue/compSvcInfoSync/1.0.0";

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

}
