package cn.com.duiba.constant;

import com.google.common.base.Splitter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Description: 屈臣氏-定制虚拟商品接口参数配置
 * @Author: fxr
 * @Date: 2019/1/3
 */
@Component
@RefreshScope
public class WatsonsConfig {

    /**
     * 屈臣氏在兑吧的appId
     */
    @Value("${watsons.watsonsAppId}")
    private String watsonsAppId;

    /**
     * 兑吧标识（请求屈臣氏时，标识兑吧身份）
     */
    @Value("${watsons.duibaIdentifier}")
    private String duibaIdentifier;

    @Value("${watsons.certiId}")
    private String certiId;

    @Value("${watsons.token}")
    private String token;

    @Value("${watsons.mallCode}")
    private String mallCode;

    private Set<Long> watsonsAppIdSet;


    @Value("${watsons.duibaIdentifier1}")
    private String duibaIdentifier1;

    @Value("${watsons.certiId1}")
    private String certiId1;

    @Value("${watsons.token1}")
    private String token1;

    @Value("${watsons.duibaIdentifier2:duiba_uat}")
    private String duibaIdentifier2;

    @Value("${watsons.certiId2:d2a6efb4fb28466f97183a16c45dee40}")
    private String certiId2;

    @Value("${watsons.token2:c0204ba2d7821cb3c539f0f1fabd2b7c}")
    private String token2;

    @Value("${watsons.appSecret:AYqESaLN9PF2Vs1D}")
    private String appSecret;

    @Value("${watsons.apiSwitchTime:1600240845988}")
    private Long apiSwitchTime;

    @Value("${watsons.isUpdate:1}")
    private Integer isUpdate;

    @Value("${watsons.brandId:100000003}")
    private String brandId;

    @Value("${watsons.channelId:200000033}")
    private String channelId;

    @Value("${watsons.newAppId:300000036}")
    private String newAppId;

    @Value("${watsons.newSecret:5a9c5d8a50734b348373d67c94ae4b9c}")
    private String newSecret;

    public String getNewAppId() {
        return newAppId;
    }

    public void setNewAppId(String newAppId) {
        this.newAppId = newAppId;
    }

    public String getNewSecret() {
        return newSecret;
    }

    public void setNewSecret(String newSecret) {
        this.newSecret = newSecret;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getDuibaIdentifier() {
        return duibaIdentifier;
    }

    public String getWatsonsAppId() {
        return watsonsAppId;
    }

    public String getCertiId() {
        return certiId;
    }

    public String getToken() {
        return token;
    }

    public String getMallCode() {
        return mallCode;
    }

    public String getDuibaIdentifier1() {
        return duibaIdentifier1;
    }

    public String getCertiId1() {
        return certiId1;
    }

    public String getToken1() {
        return token1;
    }

    public String getDuibaIdentifier2() {
        return duibaIdentifier2;
    }

    public void setDuibaIdentifier2(String duibaIdentifier2) {
        this.duibaIdentifier2 = duibaIdentifier2;
    }

    public String getCertiId2() {
        return certiId2;
    }

    public void setCertiId2(String certiId2) {
        this.certiId2 = certiId2;
    }

    public String getToken2() {
        return token2;
    }

    public void setToken2(String token2) {
        this.token2 = token2;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public Long getApiSwitchTime() {
        return apiSwitchTime;
    }

    public void setApiSwitchTime(Long apiSwitchTime) {
        this.apiSwitchTime = apiSwitchTime;
    }

    public Set<Long> getWatsonsAppIdSet() {
        if (StringUtils.isBlank(watsonsAppId)) {
            return Collections.emptySet();
        }
        if (CollectionUtils.isNotEmpty(watsonsAppIdSet)) {
            return watsonsAppIdSet;
        }
        watsonsAppIdSet = Splitter.on(",").omitEmptyStrings().splitToList(watsonsAppId).stream().map(Long::parseLong).collect(Collectors.toSet());
        return watsonsAppIdSet;
    }

    public Integer getIsUpdate() {
        return isUpdate;
    }

    public void setIsUpdate(Integer isUpdate) {
        this.isUpdate = isUpdate;
    }

    public boolean isUpdate() {
        return !Objects.equals(1, isUpdate);
    }
}
