package cn.com.duiba.constant.ginoble;


import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.GinobleApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 基诺浦配置
 *
 * @author fja
 *
 *
 * (测试)加减积分：https://staging-business-api.maiscrm.com/v2/batch/members/updateScore
 * (正式)加减积分：https://business-api.maiscrm.com/v2/batch/members/updateScore
 */
@Configuration
@ConfigurationProperties(prefix = "ginoble")
public class GinobleConfig implements InitializingBean {
    @Resource
    private GinobleApiStrategy ginobleApiStrategy;


    private Set<Long> appIds = Sets.newHashSet(-1L);

    /**
     * 测试：eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NTUyNzU1MDYsImV4cCI6NDgwODg3NTUwNiwiaXNzIjoicG9ydGFsIiwiYXVkIjoib3BlbkFQSSIsImFpZCI6IjYyYTk3ZjBkYmYyY2Y2NDEzMzEzNTk4MiIsInN1YiI6ImFwcDo2MmE5N2ZmMjAyNTBiOTAwMDkxZmU0ZjMiLCJ1bmlxIjoiMjEwNjk5OTAwMTYyYTk3ZmYyMWVlNmY0LjA4NzE3MjY1In0.1CcDc-Uid1m7Op67BonUUMT-s8PXawPmyh-6T3xJQkk
     * 生产：eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NTY0Nzg4NDMsImV4cCI6NDgxMDA3ODg0MywiaXNzIjoicG9ydGFsIiwiYXVkIjoib3BlbkFQSSIsImFpZCI6IjYyOGIwYTQzOTBhZGNmNGY2NDJiNmQwNiIsInN1YiI6ImFwcDo2MmJiZGM3YjM3Njk5ZDUxYTg3YjJlNDMiLCJ1bmlxIjoiMTAyMTEzODE3OTYyYmJkYzdiMjQwYzc1LjkwMTU1MDIxIn0.CJTfrHF6J00VRkvA6lT0Fq_hXcFj9PPHqEhqq8xITu4
     */
    private String xAccessToken = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NTUyNzU1MDYsImV4cCI6NDgwODg3NTUwNiwiaXNzIjoicG9ydGFsIiwiYXVkIjoib3BlbkFQSSIsImFpZCI6IjYyYTk3ZjBkYmYyY2Y2NDEzMzEzNTk4MiIsInN1YiI6ImFwcDo2MmE5N2ZmMjAyNTBiOTAwMDkxZmU0ZjMiLCJ1bmlxIjoiMjEwNjk5OTAwMTYyYTk3ZmYyMWVlNmY0LjA4NzE3MjY1In0.1CcDc-Uid1m7Op67BonUUMT-s8PXawPmyh-6T3xJQkk";

    /**
     * 测试：62a97f0dbf2cf64133135982
     * 生产：628b0a4390adcf4f642b6d06
     */
    private String xAccountId = "62a97f0dbf2cf64133135982";




    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getxAccessToken() {
        return xAccessToken;
    }

    public void setxAccessToken(String xAccessToken) {
        this.xAccessToken = xAccessToken;
    }

    public String getxAccountId() {
        return xAccountId;
    }

    public void setxAccountId(String xAccountId) {
        this.xAccountId = xAccountId;
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(appIds, ginobleApiStrategy);
    }
}
