package cn.com.duiba.constant.kouweiwang;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.kouweiwang.KwwApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.dto.kww.KwwDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 口味王配置
 *
 * @author fja
 * <p>
 * 测试uid: 1714509202724843
 */
@Configuration
@ConfigurationProperties(prefix = "kww")
public class KwwConfig implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(KwwConfig.class);

    @Resource
    private KwwApiStrategy kwwApiStrategy;

    /**
     * aes key的长度
     */
    private final static int AES_KEY_LENGTH = 1 << 4;

    /**
     * 补位数组
     */
    private final static byte[] PLUS_BYTES = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f};

    /**
     * 系统接入标识appId
     */
    private String kwwAppId = "fe58098190012a428cbb9c1cf7d2f693";

    /**
     * 秘钥
     */
    private String kwwAppSecret = "5a456ae9ddd3a74b3ae8e17202dc1a5a";

    private String pushUrl;

    private Map<Long, KwwDto> pushUrlMap = MapUtils.EMPTY_MAP;

    /**
     * 口味王 aesKey
     */
    private byte[] aesKey;

    public Set<Long> getAppIdSet() {
        return pushUrlMap.keySet();
    }

    public String getKwwAppId() {
        return kwwAppId;
    }

    public void setKwwAppId(String kwwAppId) {
        this.kwwAppId = kwwAppId;
    }

    public String getKwwAppSecret() {
        return kwwAppSecret;
    }

    public void setKwwAppSecret(String kwwAppSecret) {
        this.kwwAppSecret = kwwAppSecret;
    }

    public byte[] getAesKey() {
        return aesKey;
    }

    public String getPushUrl() {
        return pushUrl;
    }

    public void setPushUrl(String pushUrl) {
        this.pushUrl = pushUrl;
    }

    public Map<Long, KwwDto> getPushUrlMap() {
        return pushUrlMap;
    }

    public void setPushUrlMap(Map<Long, KwwDto> pushUrlMap) {
        this.pushUrlMap = pushUrlMap;
    }

    @Override
    public void afterPropertiesSet() throws BizException {
        try{
            List<KwwDto> kwwUrlList = JSONObject.parseArray(pushUrl, KwwDto.class);
            if(CollectionUtils.isNotEmpty(kwwUrlList)){
                pushUrlMap = kwwUrlList.stream().filter(kwwDto -> kwwDto.getAppId() != null).collect(Collectors.toMap(KwwDto::getAppId, Function.identity(), (old, newa) -> newa));
            }
        }catch (Exception e) {
            LOGGER.warn("kww配置初始化失败，pushUrl={}", pushUrl);
        }

        if(MapUtils.isEmpty(pushUrlMap)){
            LOGGER.warn("kww配置初始化失败，pushUrl={}", pushUrl);
            return;
        }
        ApiStrategyRouter.register(pushUrlMap.keySet(), kwwApiStrategy);
        //生成aes key
        this.aesKey = genAesKey();
    }


    /**
     * 生成aes key，密钥长度不足需要补位
     *
     * @return aes key
     * @throws BizException 配置异常
     */
    private byte[] genAesKey() throws BizException {
        if (StringUtils.isBlank(kwwAppSecret)) {
            throw new BizException("appSecret为空，检查apollo配置，namespace=kww，key=kww.kwwAppSecret");
        }

        //秘钥需要补多少字符
        int plus = AES_KEY_LENGTH - kwwAppSecret.length();

        byte[] secretBytes = kwwAppSecret.getBytes(StandardCharsets.UTF_8);
        byte[] aesKey = new byte[AES_KEY_LENGTH];

        for (int i = 0; i < AES_KEY_LENGTH; i++) {
            if (secretBytes.length > i) {
                aesKey[i] = secretBytes[i];
            } else {
                aesKey[i] = PLUS_BYTES[plus];
            }
        }

        return aesKey;
    }
}
