package cn.com.duiba.dao.custom.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.custom.ZHCreditsLogDAO;
import cn.com.duiba.domain.ZHCreditsLogDO;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.enums.zhcreditslog.LogStatusEnum;
import cn.com.duiba.enums.zhcreditslog.LogTypeEnum;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by 歪大哥😁 on 2019-10-23.
 */
@Component
public class ZHCreditsLogDAOImpl extends BaseDAO implements ZHCreditsLogDAO {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZHCreditsLogDAOImpl.class);

    @Resource(name="stringRedisTemplate")
    private RedisAtomicClient redisCounter;

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.DUIBA_CUSTOM;
    }

    @Override
    public ZHCreditsLogDO findByRequestSn(String requestSn) {
        return selectOne("findByRequestSn", requestSn);
    }

    @Override
    public Long insert(ZHCreditsLogDO entity) {
        insert("insert", entity);
        return entity.getId();
    }

    @Override
    public ZHCreditsLogDO findByOrderNumAndLogType(String orderNum, LogTypeEnum logType) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("orderNum", orderNum);
        params.put("logType", logType);
        return selectOne("findByOrderNumAndLogType", params);
    }

    @Override
    public boolean updateLogStatus(Long id, LogStatusEnum update, LogStatusEnum expect) {
        if (id == null || update == null || expect == null) {
            return false;
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("id", id);
        params.put("update", update.getCode());
        params.put("expect", expect.getCode());
        return update("updateLogStatus", params) == 1;
    }

    @Override
    public boolean updateResponseInfo(Long id, String responseInfo) {
        if (id == null || StringUtils.isBlank(responseInfo)) {
            return false;
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("id", id);
        if (responseInfo.length() > 255) {
            responseInfo = responseInfo.substring(0, 255);
        }
        params.put("responseInfo", responseInfo);
        return update("updateResponseInfo", params) == 1;
    }

    @Override
    public String generateNewRequestSn(String partnerCode) throws BizException {
        // 获取当前分钟的时间戳
        long sec = System.currentTimeMillis() / 60000;
        // 将秒数加入key生成逻辑中
        String counterKey = RedisKeyEnum.K001.toString() + sec;
        long offset = redisCounter.incrBy(counterKey, 1, 5, TimeUnit.MINUTES);
        if (offset > 999999) {
            // 当前分钟已经达到上限  按照需求方直接失败当次扣积分请求
            LOGGER.warn("中宏积分接口对接，当前已达到业务上限，中断流程");
            throw new BizException("中宏积分业务已达上限");
        }
        String requestSn = partnerCode + sec * 1000000 + offset + "";
        return java.util.UUID.nameUUIDFromBytes((requestSn).getBytes()).toString();
    }

}
