package cn.com.duiba.enums.union;

/**
 * @Description 银联商品赠送用户身份类型
 * @Date 2022/3/11
 * @Author WeiChaoChao
 */
public enum UnionGoodsUserSendType {
    /**
     * 银联优惠券手机号
     */
    COUPON_MOBILE("01", "UnionCouponMobile"),
    /**
     * 银联优惠券openId
     */
    COUPON_OPEN_ID("03", "UnionCouponOpenId"),
    /**
     * 银联直接出奖手机号
     */
    LOTTERY_MOBILE("01", "UnionLotteryMobile"),
    /**
     * 银联直接出奖openId
     */
    LOTTERY_OPEN_ID("03", "UnionLotteryOpenId"),
    ;
    /**
     * 赠送类型
     */
    private String acctEntityTp;
    /**
     * 优惠券商品前缀
     */
    private String goodsPrefix;

    UnionGoodsUserSendType(String acctEntityTp, String goodsPrefix) {
        this.acctEntityTp = acctEntityTp;
        this.goodsPrefix = goodsPrefix;
    }


    public String getAcctEntityTp() {
        return acctEntityTp;
    }

    public void setAcctEntityTp(String acctEntityTp) {
        this.acctEntityTp = acctEntityTp;
    }

    public String getGoodsPrefix() {
        return goodsPrefix;
    }

    public void setGoodsPrefix(String goodsPrefix) {
        this.goodsPrefix = goodsPrefix;
    }

}
