package cn.com.duiba.enums.zhcreditslog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

/**
 * 积分日志状态
 * Created by 歪大哥😁 on 2019-10-24.
 */
public enum LogStatusEnum {

    // 已创建
    CREATED(0),
    // 已发送
    SENT(100),
    // 已响应
    RESPONDED(200),
    ;

    private static final ImmutableMap<Integer, LogStatusEnum> ALL_MAPPING;

    static {
        Map<Integer, LogStatusEnum> temp = Maps.newHashMap();
        for (LogStatusEnum value : values()) {
            temp.put(value.code, value);
        }
        ALL_MAPPING = ImmutableMap.copyOf(temp);
    }

    @CheckForNull
    public static LogStatusEnum getByCode(Integer code) {
        return ALL_MAPPING.get(code);
    }

    private int code;

    public int getCode() {
        return code;
    }

    LogStatusEnum(int code) {
        this.code = code;
    }

}
