package cn.com.duiba.notifycenter.remoteimpl;

import cn.com.duiba.constant.DelayNotifyConfig;
import cn.com.duiba.constant.SkipNotifyConfig;
import cn.com.duiba.constant.kouweiwang.KwwConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.mq.RocketMQTopicConstant;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.thirdparty.api.RemoteNotifyDeveloperService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.DelayMsgConfigNameEnum;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 通知服务接口
 */
@RestController
public class RemoteNotifyQueueServiceImpl implements RemoteNotifyDeveloperService {

	private static Logger log = LoggerFactory.getLogger(RemoteNotifyQueueServiceImpl.class);

	@Autowired
	private NotifyQueueDAO notifyQueueDAO;
	@Autowired
	private NotifyService notifyService;

	@Autowired
	private SkipNotifyConfig skipNotifyConfig;

	@Autowired
	private DelayNotifyConfig delayNotifyConfig;

	@Autowired
	private RocketMQMsgProducer rocketMQMsgProducer;

	@Autowired
	private RocketMQTopicConstant rocketMQTopicConstant;

	@Autowired
	private KwwConfig kwwConfig;


	@Override
	public void notifyDeveloper(NotifyQueueDto notifyQueue) {
		try {
			if (skipNotifyConfig.hasNotNotify(notifyQueue.getAppId(), notifyQueue.getResult())) {
				log.info("the app skip notify, appId={}", notifyQueue.getAppId());
				return;
			}
			//口味王定制：活动加减积分的通知都屏弊掉，否则会传给他们那边，他们会去找相应订单，但活动的是不会产生订单的
			if(kwwConfig.getAppIdSet().contains(notifyQueue.getAppId()) && !Objects.equals(NotifyQueueDto.RT_MAINORDERS, notifyQueue.getRelationType())){
				log.info("the app skip notify, appId={}", notifyQueue.getAppId());
				return;
			}

			NotifyQueueDO queue = BeanUtils.copy(notifyQueue, NotifyQueueDO.class);
			DBTimeProfile.enter("insert");
			if(queue.getTimes() == null){
                queue.setTimes(0);
			}
			if(queue.getNotifyType() == null){//默认结果通知，向上兼容
				queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
			}
			if(NotifyTypeEnum.getByCode(queue.getNotifyType())==null){
				throw new Exception("通知类型不存在;queue:"+ JSON.toJSONString(queue));
			}

			String errorMsg = queue.getError4developer();
			if(StringUtils.isNotBlank(errorMsg) && errorMsg.length() > 600){
				queue.setError4developer(errorMsg.substring(0, 600));
			}
			//判断消息是否需要延时发送
			if (delayNotifyConfig.ifNeedDelay(queue.getAppId())) {
				log.info("[万达酒店] remote延时发送");
				JSONObject json = (JSONObject) JSONObject.toJSON(queue);
				Integer delayLevel = Optional.ofNullable(DelayNotifyConfig.getDelayLevels(queue.getAppId())).orElse(0);
				json.put(DelayMsgConfigNameEnum.DELAY_LEVEL.getName(), delayLevel);
				rocketMQMsgProducer.sendMsg(rocketMQTopicConstant.getDelayMsg(), "remote", "", json.toJSONString(), false, null);
				DBTimeProfile.release();
				return;
			}
			notifyQueueDAO.insert(queue);
			DBTimeProfile.release();
			DBTimeProfile.enter("notify");
			notifyService.notify(queue, "remote call");
			DBTimeProfile.release();
		} catch (Exception e) {
			log.error("notify error", e);
		}
	}


	public static void main(String[] args) {
		String url = "https://ecomm.generalichina.com/testapi/credit/third/duiba/minusintegral?actualPrice=0&ip=221.12.18.35&itemCode=123&sign=170ed0ab251727f9c9ea938a8b01fb8f&description={\"channel\":1,\"count\":1,\"detail\":[{\"amount\":1,\"name\":\"兑换实物：扣积分测试\",\"originPrice\":1,\"price\":1}],\"sn\":\"181341282116202C0817\",\"userId\":\"00000035\"}&orderNum=181341282116202C0817&waitAudit=false&type=object&params=测试:13078788989:北京市:北京市:东城区:东华门街道:测试&uid=00000035&credits=1&facePrice=100&appKey=3n5TgKxmMy1kYhuddr2K84o1YyHm&timestamp=1636426459026&";
		Map<String, String> urlParams = AssembleTool.getUrlParams(url.substring(url.indexOf("?") + 1));
		urlParams.remove("sign");
		urlParams.put("appSecret","eEC4FbTJmKvqrufjAGLna1MTs6J");
		System.out.println(urlParams.toString());
		String sign = SignTool.sign(urlParams);
		System.out.println("sign:"+sign);
		urlParams.put("sign",sign);
		System.out.println(urlParams.toString());

	}
}
