package cn.com.duiba.orderstatus;

import cn.com.duiba.crecord.message.CrecordAsyncHttp;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.job.AbstractDuibaSimpleElasticJob;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import io.elasticjob.autoconfigure.annotation.ElasticJob;
import io.elasticjob.lite.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 订单状态变更同步失败，定时任务
 */
@ElasticJob(name = "orderPushRetryJob", cron = "0/30 * * * * ?", shardingTotalCount = 1, overwrite = true)
public class OrderPushRetryJob extends AbstractDuibaSimpleElasticJob {

	private Logger log = LoggerFactory.getLogger(OrderPushRetryJob.class);

	@Autowired
	private HttpMessageDAO httpMessageDAO;
	@Autowired
	private OrderStatusPushHttp toDeveloper;
	@Autowired
	private AppDAO appDAO;

	@SuppressWarnings("unchecked")
	@Override
	public void doProcess(ShardingContext shardingContext) {
		try {
			log.info("started retry orderStatusPush:{}", DateUtils.getSecondStr(new Date()));
			List<HttpMessageDO> dos = httpMessageDAO.findNeedRetry(HttpRequestMessageDto.ORDER_STATUS_PUSH, 5000);
			Map<Long, AppDO> appMap = new HashMap<>();
			Set<Long> appIds = new HashSet<>();
			for (HttpMessageDO db : dos) {
				appIds.add(db.getAppId());
			}
			for (Long appId : appIds) {
				AppDO app = appDAO.findAppSimple(appId);
				appMap.put(appId, app);
			}
			for (HttpMessageDO db : dos) {
				try {
					AppDO app = appMap.get(db.getAppId());
					HttpRequestMessageDto dto = new HttpRequestMessageDto();
					dto.setAppId(db.getAppId());
					dto.setBizType(db.getBizType());
					Map<String, String> httpParams = JSONObject.parseObject(db.getBizParams(), Map.class);
					dto.setHttpParams(httpParams);
					toDeveloper.asyncSubmit(db, dto, app);
				} catch (Exception e) {
					log.info("OrderPushRetryJob error appId:}",db.getAppId(), e);
				}
			}
		} catch (Exception e) {
			log.error("OrderPushRetryJob error:", e);
		}
	}

}
