package cn.com.duiba.remoteimpl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.thirdparty.api.RemoteConsumerCreditsLogService;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import cn.com.duiba.tool.ErrorCode;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author fss
 */
@RestController
public class RemoteConsumerCreditsLogServiceImpl implements RemoteConsumerCreditsLogService {

    @Resource
    private ConsumerCreditsLogService consumerCreditsLogService;

    /**
     * 过期biz类型
     */
    private static final String EXPIRE_BIZ_TYPE = "EXPIRE";

    @Override
    public Long saveExpireLog(ConsumerCreditsLogSaveDto consumerCreditsLogSaveDto) throws BizException {
        if (Objects.isNull(consumerCreditsLogSaveDto) || !EXPIRE_BIZ_TYPE.equals(consumerCreditsLogSaveDto.getBizType()) || Objects.isNull(consumerCreditsLogSaveDto.getGmtCreate())) {
            throw new BizException(ErrorCode.E0001001.getErrorCode());
        }
        return consumerCreditsLogService.saveExpireRecords(consumerCreditsLogSaveDto);
    }
}
