package cn.com.duiba.remoteimpl.mengniu;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.MengNiuConfig;
import cn.com.duiba.thirdparty.api.mengniu.RemoteMengNiuService;
import cn.com.duiba.thirdparty.dto.mengniu.MengNiuGoodsDto;
import cn.com.duiba.thirdparty.dto.mengniu.MengNiuStockDto;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @date:2022/6/8 10:47
 * @author:zhaozhanghai
 * @Description:
 */
@RestController
public class RemoteMengNiuServiceImpl  implements RemoteMengNiuService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteMengNiuServiceImpl.class);
    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    private String mengniuAccessTokenKey="mengniu-accesstoken-key";

    @Autowired
    private MengNiuConfig mengNiuConfig;

//  0 正常
//-1 系统繁忙请稍后再试
//40001 accessToken 失效
//40002 调⽤被限流（峰值 qps 100）
// 40003 ⼊参错误


    @Override
    public void syncGoods(MengNiuGoodsDto mengNiuGoodsDto) throws BizException {
        String syncGoodsUrl = mengNiuConfig.getSyncGoodsUrl() + "?accessToken=" + getAccessToken();
        String param = JSONObject.toJSONString(mengNiuGoodsDto);
        LOGGER.info("蒙牛syncGoods，url:{}，param:{}",syncGoodsUrl,param);
        String body = HttpUtil.post(syncGoodsUrl, param);
        LOGGER.info("蒙牛syncGoods，url:{}，param:{},body:{}",syncGoodsUrl,param,body);
        if (check(body)) {return;}
        throw new BizException("蒙牛同步商品失败");
    }


    @Override
    public void syncStock(MengNiuStockDto mengNiuStockDto) throws BizException {
        String syncStockUrl = mengNiuConfig.getSyncStockUrl() + "?accessToken=" + getAccessToken();
        String param = JSONObject.toJSONString(mengNiuStockDto);
        LOGGER.info("蒙牛syncStock，url:{}，param:{}",syncStockUrl,param);
        String body = HttpUtil.post(syncStockUrl, param);
        LOGGER.info("蒙牛syncStock，url:{}，param:{},body:{}",syncStockUrl,param,body);
        if (check(body)) {return;}
        throw new BizException("蒙牛同步库存失败");
    }

    private boolean check(String body) {
        JSONObject jsonObject = JSONObject.parseObject(body);
        if (isSucc(jsonObject)) {
            JSONObject data = jsonObject.getJSONObject("data");
            if (Objects.nonNull(data) && data.getBoolean("success")) {
                return true;
            }
        }
        return false;
    }

    private String getAccessToken() throws BizException {
        String accessToken= redisTemplate.opsForValue().get(mengniuAccessTokenKey);
        if (StringUtils.isNotEmpty(accessToken)){
            return accessToken;
        }
        String accessTokenUrl = mengNiuConfig.getAccessTokenUrl();
        accessTokenUrl+="?appid="+mengNiuConfig.getMengniuAppId()+"&secret="+mengNiuConfig.getMengniuSecret();
        LOGGER.info("蒙牛getAccessToken，url:{}",accessTokenUrl);
        String body = HttpUtil.get(accessTokenUrl);
        LOGGER.info("蒙牛getAccessToken-result，body:{}",body);
        JSONObject jsonObject = JSONObject.parseObject(body);
        if (isSucc(jsonObject)){
            JSONObject data = jsonObject.getJSONObject("data");
            accessToken = data.getString("accessToken");
            Integer expiresIn = data.getInteger("expiresIn");
            if (StringUtils.isNotEmpty(accessToken) && Objects.nonNull(expiresIn)){
                redisTemplate.opsForValue().set(mengniuAccessTokenKey,accessToken,expiresIn-100, TimeUnit.SECONDS);
                return accessToken;
            }
        }
        throw new BizException("蒙牛获取accessToken失败");
    }

    private boolean isSucc(JSONObject jsonObject) {
        return jsonObject.getInteger("ec")==200 && Objects.equals(jsonObject.getString("em"),"success");
    }
}
