package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.constant.qingtian.QingTianConfig;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import cn.com.duiba.tool.fulu.FuLuUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/**
 * 长城汽车定制 虚拟商品以为
 * @author cmm
 */
@Service
public class QingTianApiStrategy extends AbstractDuibaVirtualSupplier {
    private static final Logger log = LoggerFactory.getLogger(QingTianApiStrategy.class);

    @Autowired
    private QingTianConfig qingTianConfig;
    @Autowired
    private AppDAO appDAO;

    private static final String PHONE_REGEX = "^1[3456789]\\d{9}$";

    private static final String QQ_REGEX = "(^[1-3]{1}\\d{4,9}$)|(^[1-9]{1}\\d{4,8}$)";

    private static final Set<Integer> processSet = Sets.newHashSet(2000);

    /**
     * 获取晴天直充下单请求体
     * @param request
     * @return
     */
    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto request) {
        log.info("晴天直充---SupplierRequest:{}",JSON.toJSONString(request));
        Map<String, String> params = request.getParams();
        //兑吧订单号
        String orderNum = params.get("orderNum");
        //用户兑换虚拟商品时输入的账号
        String account = params.get("account");
        //商品id 从编码中获取
        String projectId = params.get("bizParams");
        //账号类型
        String rechargeAccount = "0";
        Pattern p = Pattern.compile(PHONE_REGEX, Pattern.CASE_INSENSITIVE);
        if(p.matcher(account).matches()) {
            rechargeAccount = "1";
        }
        p = Pattern.compile(QQ_REGEX, Pattern.CASE_INSENSITIVE);
        if(p.matcher(account).matches()) {
            rechargeAccount = "2";
        }

        AppDO appDO = appDAO.getAppByCache(Long.valueOf(request.getAppId()));
        String subject = appDO.getSubject().toString();

        String merchantId = SubjectTypeEnum.DUIBA.getType().equals(subject)? qingTianConfig.getDuibaMerchantId() : qingTianConfig.getDuiaMerchantId();
        String appKey = SubjectTypeEnum.DUIBA.getType().equals(subject)? qingTianConfig.getDuibaAppKey() : qingTianConfig.getDuiaAppKey();
        log.info("晴天虚拟商品对接请求主体:{}, merchantId={},appKey={}", SubjectTypeEnum.getDescByType(subject), merchantId, appKey);

        //拼装请求
        HttpPost httpPost = new HttpPost(qingTianConfig.getHost() + qingTianConfig.getUrl());
        Map<String, String> data = new HashMap<>();
        data.put("merchantId", merchantId);
        data.put("outTradeNo", orderNum);
        data.put("productId", projectId);
        data.put("rechargeAccount", account);
        data.put("accountType", rechargeAccount);
        data.put("number", "1");
        //精确到秒
        data.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000));
        data.put("notifyUrl", qingTianConfig.getNotifyUrl());
        data.put("sign", generateSignature(data, appKey));
        data.put("version", "1.0");
        String dataStr = mapToString(data);
        StringEntity stringEntity = new StringEntity(dataStr, "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("text/plain");
        httpPost.setEntity(stringEntity);
        log.info("晴天请求参数,httpPost={},data={}", JSON.toJSONString(httpPost), JSON.toJSONString(data));
        return httpPost;
    }

    private String mapToString(Map<String, String> data) {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = data.keySet();
        String[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        for (String k : keyArray) {
            // 参数值为空，则不参与签名
            if (data.get(k).trim().length() > 0) {
                sb.append(k).append("=").append(data.get(k).trim()).append("&");
            }
        }
        return sb.toString();
    }

    private String generateSignature(final Map<String, String> data, String key){
        String dataStr = mapToString(data);
        dataStr += "key=" + key;
        log.info("晴天待签名的数据" + dataStr);
        String sign = "";
        try {
            sign = MD5.md5(dataStr);
        } catch (Exception e) {
            log.warn("晴天签名失败,data={}" + dataStr, e);
        }
        return sign.toUpperCase();
    }

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.QING_TIAN.getCode();
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        log.info("晴天供应商,请求返回结果处理,request:{},body:{}", JSONObject.toJSONString(request), body);
        JSONObject result = new JSONObject();
        try {
            JSONObject responseJson = JSONObject.parseObject(body);
            Integer responseCode = responseJson.getInteger("code");
            if(processSet.contains(responseCode)) {
                result.put("status", "process");
            } else {
                result.put("status", "fail");
                result.put("errorMessage", responseJson.getString("message"));
            }
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("errorMessage", e.getMessage());
            log.info("晴天供应商,解析虚拟商品兑换请求结果异常,orderId=" + request.getOrderId(), e);
        }
        return result.toJSONString();
    }
}
