package cn.com.duiba.tool;

import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @Description: 趣头条-签名工具类
 * @Author: fxr
 * @Date: 2019/4/2
 */
public class FunHeadlinesSignTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunHeadlinesSignTool.class);

    /**
     * 十六进制(不足两位，前面补0输出；如果超过两位，则实际输出)
     */
    private static final String HEXADECIMAL_ZERO_PADDING_FORMAT = "%02x";

    /**
     * 签名算法
     */
    private static final String SIGNATURE_ARITHMETIC = "MD5";

    /**
     * 签名串
     */
    private static final String SIGN_PARAM = "sign";

    /**
     * appkey
     */
    private static final String APP_KEY = "app_key";


    /**
     * 签名
     *
     * @param paramMap
     * @param appKey
     * @return
     */
    public static String sign(Map<String, String> paramMap, String appKey) {
        paramMap.remove(SIGN_PARAM);
        paramMap.put(APP_KEY, appKey);
        List<String> keys = Lists.newArrayList();
        keys.addAll(paramMap.keySet());
        keys.sort((l, r) -> {
            int i = l.compareTo(r);
            if (i > 0) {
                return 1;
            } else {
                return -1;
            }
        });
        String r;
        String hashed = "";
        r = keys.stream().map(i -> i + paramMap.get(i)).collect(Collectors.joining());
        try {
            hashed = getMD5(r);
        } catch (Exception e) {
            LOGGER.error("[FunHeadlinesSignTool-sign]趣头条-签名错误：", e);
        }
        paramMap.remove(APP_KEY);
        return hashed;
    }

    /**
     * 校验签名
     *
     * @param paramMap
     * @param appKey
     * @return
     * @throws Exception
     */
    public static boolean checkSign(Map<String, String> paramMap, String appKey) throws Exception {
        String originSign = paramMap.get(SIGN_PARAM);
        if (StringUtils.isBlank(originSign)) {
            throw new Exception("签名错误");
        }
        String sign = sign(paramMap, appKey);
        if (!originSign.equals(sign)) {
            throw new Exception("签名错误");
        }
        return true;
    }

    private static String getMD5(String need2Encode) throws NoSuchAlgorithmException {
        byte[] buf = need2Encode.getBytes();
        MessageDigest md5 = MessageDigest.getInstance(SIGNATURE_ARITHMETIC);
        md5.update(buf);
        byte[] tmp = md5.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : tmp) {
            sb.append(String.format(HEXADECIMAL_ZERO_PADDING_FORMAT, b & 0xff));
        }
        return sb.toString();
    }
}

