package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.NewInoherbConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;

public class InoherbTools {
    private final static String EXCHANGE = "exchange";
    private final static String OTHERS = "others";
    private final static String SUB_SUFFIX = "Sub";
    private final static String ADD_SUFFIX = "Add";
    private final static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /**
     * 生成签名
     *
     * @param params 参数
     * @return 签名
     */
    public static String genSign(Map<String, Object> params, String appsecret) {
        String[] str = params.keySet().toArray(new String[]{});
        Arrays.sort(str);
        StringBuilder signatureStr = new StringBuilder();
        signatureStr.append(appsecret);
        for (String key : str) {
            Object value = params.get(key);
            if (value != null && value != "") {
                signatureStr.append(key).append(value);
            }
        }
        signatureStr.append(appsecret);
        String sign = MD5(signatureStr.toString());
        // 生成sign(签名)
        return sign.toUpperCase();
    }


    private static String MD5(String s) {
        try {
            byte[] strTemp = s.getBytes("UTF-8");
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = HEX_DIGITS[byte0 >>> 4 & 15];
                str[k++] = HEX_DIGITS[byte0 & 15];
            }
            return new String(str);
        } catch (Exception var9) {
            return null;
        }
    }

    /**
     * @param originData
     * @param inoherbConfig
     * @param isSub
     * @return
     */
    public static int locateProcessType(Map<String, String> originData, NewInoherbConfig inoherbConfig, boolean isSub) {
        examineProperties(inoherbConfig);
        Map<String, Integer> map = JSON.parseObject(inoherbConfig.getProcessTypes(), Map.class);
        String type = originData.get("type");
        if (type == null) {
            return map.get(EXCHANGE);
        }
        //活动
        else if (type.equalsIgnoreCase("hdtool")
                || type.equalsIgnoreCase("game")
                || type.equalsIgnoreCase("sign")) {
            return isSub ? map.get(type + SUB_SUFFIX) : map.get(type + ADD_SUFFIX);
        }
        //兑换
        else {
            return map.get(EXCHANGE);
        }
    }

    /**
     * 虚拟商品加积分 processType
     *
     * @param inoherbConfig
     * @return
     */
    public static int locateVirtualProcessType(NewInoherbConfig inoherbConfig) {
        examineProperties(inoherbConfig);
        Map<String, Integer> map = JSON.parseObject(inoherbConfig.getProcessTypes(), Map.class);
        return map.get("game" + ADD_SUFFIX);
    }

    public static int locateIssueType(Integer processType, NewInoherbConfig inoherbConfig) {
        examineProperties(inoherbConfig);
        Map<String, Integer> processTypes = JSON.parseObject(inoherbConfig.getProcessTypes(), Map.class);
        Map<String, Integer> issueTypes = JSON.parseObject(inoherbConfig.getIssueTypes(), Map.class);
        return processType.compareTo(processTypes.get(EXCHANGE)) == 0 ? issueTypes.get(EXCHANGE) : issueTypes.get(OTHERS);
    }

    /**
     * 获取域名
     *
     * @param message 数据
     * @return host
     */
    public static String getHostName(CreditsMessageDto message) {
        String url = message.getHttpUrl();
        return url.substring(0, url.indexOf('?'));
    }

    public static String getHostName(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        return url.substring(0, url.indexOf('?'));
    }

    /**
     * 校验配置项
     * @param inoherbConfig 配置
     */
    private static void examineProperties(NewInoherbConfig inoherbConfig) {
        if (StringUtils.isBlank(inoherbConfig.getProcessTypes())) {
            throw new ThirdpatyException("缺少必要配置inoherb.new.processTypes");
        }
        if (StringUtils.isBlank(inoherbConfig.getIssueTypes())) {
            throw new ThirdpatyException("缺少必要配置inoherb.new.issueTypes");
        }
    }
}
