package cn.com.duiba.tool;

import org.apache.log4j.Logger;

import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;

/**
 * 对外接口SIGN验证
 */
public class WatsonsSignUtil {
    private static Logger logger = Logger.getLogger(WatsonsSignUtil.class);

    /**
     * 二行制转字符串
     */
    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (byte aB : b) {
            stmp = (Integer.toHexString(aB & 0XFF));
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
            } else {
                hs.append(stmp);
            }
        }
        return hs.toString().toUpperCase();
    }

    /**
     * 把所有参数值转码
     *
     * @param params
     * @return
     */
    public static TreeMap<String, String> convertEncodeToMap(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        Iterator it = params.entrySet().iterator();
        TreeMap<String, String> map = new TreeMap<>();
        while (it.hasNext()) {
            Entry obj = (Entry) it.next();
            String name = obj.getKey().toString();
            Object[] valueObj = (Object[]) obj.getValue();
            String value = valueObj[0].toString();
            map.put(name, value);
        }
        return map;
    }

    public static String getParamStr(TreeMap<String, String> params) {
        Iterator<String> iter = params.keySet().iterator();
        StringBuilder orgin = new StringBuilder("");
        while (iter.hasNext()) {
            String name = iter.next();
            orgin.append(name).append(params.get(name));
        }
        return orgin.toString();
    }

    public static String getParamStrObject(TreeMap<String, Object> params) {
        Iterator<String> iter = params.keySet().iterator();
        StringBuilder orgin = new StringBuilder("");
        while (iter.hasNext()) {
            String name = iter.next();
            orgin.append(name).append(params.get(name));
        }
        return orgin.toString();
    }

    public static String getDigest(String paramStr, String token) {
        try {
            // 两次MD5转码
            MessageDigest md = MessageDigest.getInstance("MD5");
            String firstMd = WatsonsSignUtil.byte2hex(md.digest(paramStr.getBytes("utf-8"))).toUpperCase();
            firstMd += token;
            return WatsonsSignUtil.byte2hex(md.digest(firstMd.getBytes("utf-8"))).toUpperCase();
        } catch (Exception e) {
            logger.warn(e.getMessage(), e);
            return null;
        }
    }

    /**
     * 获取签名
     *
     * @param params 传给服务器的参数
     * @param token  签名命牌
     * @return
     */
    public static String getSign(TreeMap<String, String> params, String token) {
        if (params == null) {
            return null;
        }
        String paramStr = getParamStr(params);
        return getDigest(paramStr, token);
    }

    public static String getSignWithObject(TreeMap<String, Object> params, String token) {
        if (params == null) {
            return null;
        }
        String paramStr = getParamStrObject(params);
        return getDigest(paramStr, token);
    }
}
