package cn.com.duiba.tool.ginoble;

import cn.com.duiba.constant.ginoble.GinobleConfig;
import com.google.common.collect.Maps;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.message.BasicHeader;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.Map;

/**
 * 通用工具
 *
 * @author fja
 */
@Component
public class GinobleTool {

    private final static String MINUS = "-";
    private final static String ADD = "+";
    public final static String MERCHANT_CODE_PREFIX = "GNB-";

    @Resource
    private GinobleConfig ginobleConfig;

    /**
     * 截取域名
     *
     * @param url 请求链接
     * @return 域名
     */
    public String getHostName(String url) {
        return url.substring(0, url.indexOf('?'));
    }

    /**
     * 截取参数
     *
     * @param url 请求链接
     * @return 参数
     */
    public String getParamUrl(String url) {
        return url.substring(url.indexOf('?') + 1);
    }

    /**
     * 拼装扣积分请求参数
     *
     * @param originData 数据
     * @return 扣积分请求参数
     */
    public Map<String, Object> buildSubCreditsParams(Map<String, String> originData) {
        Map<String, Object> requestParams = Maps.newHashMap();

        requestParams.put("ids", Collections.singletonList(originData.get("uid")));
        requestParams.put("score", MINUS + originData.get("credits"));
        requestParams.put("description", originData.get("description"));
        requestParams.put("identifier", originData.get("orderNum"));
        requestParams.put("businessId", originData.get("orderNum"));

        return requestParams;
    }


    /**
     * 拼装加积分请求参数
     *
     * @param originData 数据
     * @return 加积分请求参数
     */
    public Map<String, Object> buildAddCreditsParams(Map<String, String> originData) {
        Map<String, Object> requestParams = Maps.newHashMap();

        requestParams.put("ids", Collections.singletonList(originData.get("uid")));
        requestParams.put("score", originData.get("credits"));
        requestParams.put("description", originData.get("description"));
        requestParams.put("identifier", originData.get("orderNum"));
        requestParams.put("businessId", originData.get("orderNum"));

        return requestParams;
    }


    /**
     * 拼装虚拟商品加积分请求参数
     *
     * @param originData 数据
     * @return 加积分请求参数
     */
    public Map<String, Object> buildVirtualAddCreditsParams(Map<String, String> originData) {
        Map<String, Object> requestParams = Maps.newHashMap();

        String credits = originData.get("params").replace(MERCHANT_CODE_PREFIX, "");
        requestParams.put("ids", Collections.singletonList(originData.get("uid")));
        requestParams.put("score", credits);
        requestParams.put("description", originData.get("description"));
        requestParams.put("identifier", originData.get("orderNum"));
        requestParams.put("businessId", originData.get("orderNum"));

        return requestParams;
    }

    /**
     * 添加固定请求头
     *
     * @param request 请求
     */
    public void addHeaders(HttpEntityEnclosingRequestBase request) {
        BasicHeader[] headers = new BasicHeader[2];
        headers[0] = new BasicHeader("x-account-id", ginobleConfig.getxAccountId());
        headers[1] = new BasicHeader("x-access-token", ginobleConfig.getxAccessToken());
        request.setHeaders(headers);
    }
}
